/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionLanguageTransformationValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetUtils {
    public static ResolverSet getResolverSetFromStaticValues(ParameterizedModel parameterizedModel, Map<String, Object> parameters, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner) throws MuleException {
        HashMap<String, ValueResolver> resolvers = new HashMap<String, ValueResolver>();
        for (ParameterGroupModel parameterGroupModel : parameterizedModel.getParameterGroupModels()) {
            resolvers.putAll(ResolverSetUtils.getParameterGroupValueResolvers(parameterGroupModel, parameters, reflectionCache, muleContext));
        }
        return ParametersResolver.fromValues(resolvers, muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner).getParametersAsResolverSet(parameterizedModel, muleContext);
    }

    private static Map<String, ValueResolver> getParameterGroupValueResolvers(ParameterGroupModel parameterGroupModel, Map<String, Object> parameters, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        Optional<Class<?>> parameterGroupDeclaringClass;
        Optional parameterGroupModelProperty;
        Map<String, ValueResolver> parameterGroupParametersValueResolvers = ResolverSetUtils.getParameterGroupParametersValueResolvers(parameterGroupModel, parameters, reflectionCache, muleContext);
        if (parameterGroupModel.isShowInDsl() && !parameterGroupParametersValueResolvers.isEmpty() && (parameterGroupModelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class)).isPresent() && (parameterGroupDeclaringClass = ((ParameterGroupModelProperty)parameterGroupModelProperty.get()).getDescriptor().getType().getDeclaringClass()).isPresent()) {
            DefaultObjectBuilder defaultObjectBuilder = new DefaultObjectBuilder(parameterGroupDeclaringClass.get(), reflectionCache);
            for (Map.Entry<String, ValueResolver> stringValueResolverEntry : parameterGroupParametersValueResolvers.entrySet()) {
                defaultObjectBuilder.addPropertyResolver(stringValueResolverEntry.getKey(), (ValueResolver<Object>)stringValueResolverEntry.getValue());
            }
            ObjectBuilderValueResolver objectBuilderValuerResolver = new ObjectBuilderValueResolver(defaultObjectBuilder, muleContext);
            return ImmutableBiMap.of((Object)((Field)((ParameterGroupModelProperty)parameterGroupModelProperty.get()).getDescriptor().getContainer()).getName(), objectBuilderValuerResolver);
        }
        return parameterGroupParametersValueResolvers;
    }

    private static Map<String, ValueResolver> getParameterGroupParametersValueResolvers(ParameterGroupModel parameterGroupModel, Map<String, Object> parameters, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        HashMap<String, ValueResolver> parameterGroupParametersValueResolvers = new HashMap<String, ValueResolver>();
        for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
            if (!parameters.containsKey(parameterModel.getName())) continue;
            parameterGroupParametersValueResolvers.put(parameterModel.getName(), ResolverSetUtils.getParameterValueResolver(parameterModel, parameters.get(parameterModel.getName()), reflectionCache, muleContext));
        }
        return parameterGroupParametersValueResolvers;
    }

    private static ValueResolver getParameterValueResolver(ParameterModel parameterModel, Object value, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        Optional extensionParameterDescriptorModelProperty = parameterModel.getModelProperty(ExtensionParameterDescriptorModelProperty.class);
        if (!extensionParameterDescriptorModelProperty.isPresent()) {
            return new StaticValueResolver<Object>(value);
        }
        Type parameterType = ((ExtensionParameterDescriptorModelProperty)extensionParameterDescriptorModelProperty.get()).getExtensionParameter().getType();
        return ResolverSetUtils.getParameterValueResolver(parameterType, value, reflectionCache, muleContext);
    }

    private static ValueResolver getParameterValueResolver(Type parameterType, Object value, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        Class expectedType = parameterType.getDeclaringClass().orElse(null);
        if (expectedType == null) {
            return new StaticValueResolver<Object>(value);
        }
        ValueResolver valueResolver = value instanceof Collection && Collection.class.isAssignableFrom(expectedType) ? ResolverSetUtils.getParameterValueResolverForCollection(parameterType, (Collection)value, reflectionCache, muleContext) : (value instanceof Map && Map.class.isAssignableFrom(expectedType) ? ResolverSetUtils.getParameterValueResolverForMap(parameterType, (Map)value, reflectionCache, muleContext) : new ExpressionLanguageTransformationValueResolver(new StaticValueResolver<Object>(value), expectedType, (ExpressionLanguage)muleContext.getExpressionManager()));
        valueResolver = new TypeSafeValueResolverWrapper(valueResolver, expectedType);
        muleContext.getInjector().inject(valueResolver);
        LifecycleUtils.initialiseIfNeeded(valueResolver);
        return valueResolver;
    }

    private static ValueResolver getParameterValueResolverForCollection(Type parameterType, Collection collection, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        Class<Collection> expectedType = parameterType.getDeclaringClass().orElse(Collection.class);
        List<Type> parameterTypeCollectionGenerics = parameterType.getSuperTypeGenerics(Collection.class);
        if (parameterTypeCollectionGenerics.size() == 1) {
            ArrayList itemsResolvers = new ArrayList();
            for (Object collectionItem : collection) {
                itemsResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterTypeCollectionGenerics.get(0), collectionItem, reflectionCache, muleContext));
            }
            return CollectionValueResolver.of(expectedType, itemsResolvers);
        }
        return new StaticValueResolver<Collection>(collection);
    }

    private static ValueResolver getParameterValueResolverForMap(Type parameterType, Map<Object, Object> map, ReflectionCache reflectionCache, MuleContext muleContext) throws MuleException {
        Class<Map> expectedType = parameterType.getDeclaringClass().orElse(Map.class);
        List<Type> parameterTypeCollectionGenerics = parameterType.getSuperTypeGenerics(Map.class);
        if (parameterTypeCollectionGenerics.size() == 2) {
            ArrayList keyResolvers = new ArrayList();
            ArrayList valueResolvers = new ArrayList();
            for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
                keyResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterTypeCollectionGenerics.get(0), mapEntry.getKey(), reflectionCache, muleContext));
                valueResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterTypeCollectionGenerics.get(1), mapEntry.getValue(), reflectionCache, muleContext));
            }
            return MapValueResolver.of(expectedType, keyResolvers, valueResolvers, reflectionCache, muleContext);
        }
        return new StaticValueResolver<Map<Object, Object>>(map);
    }
}

