/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ParameterResolverValueResolverWrapper<T>
implements ValueResolver<ParameterResolver<T>>,
Initialisable,
MuleContextAware {
    private ValueResolver<T> resolver;
    private MuleContext muleContext;
    private final Reference<Function<ValueResolvingContext, ParameterResolver>> parameterResolverSupplier = new Reference();

    public ParameterResolverValueResolverWrapper(final ValueResolver resolver) {
        this.resolver = resolver;
        Function<ValueResolvingContext, ParameterResolver> parameterResolverFactory = context -> new ParameterResolver<T>((ValueResolvingContext)context){
            final /* synthetic */ ValueResolvingContext val$context;
            {
                this.val$context = valueResolvingContext;
            }

            public T resolve() {
                try {
                    return ResolverUtils.resolveRecursively(resolver, this.val$context);
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }

            public Optional<String> getExpression() {
                return resolver instanceof ExpressionBasedValueResolver ? Optional.ofNullable(((ExpressionBasedValueResolver)resolver).getExpression()) : Optional.empty();
            }
        };
        if (resolver.isDynamic()) {
            this.parameterResolverSupplier.set(parameterResolverFactory);
        } else {
            this.parameterResolverSupplier.set(context -> {
                ParameterResolver staticResolver = (ParameterResolver)parameterResolverFactory.apply((ValueResolvingContext)context);
                Function<ValueResolvingContext, ParameterResolver> valueResolvingContextParameterResolverFunction = ctx -> staticResolver;
                this.parameterResolverSupplier.set(valueResolvingContextParameterResolverFunction);
                return staticResolver;
            });
        }
    }

    @Override
    public ParameterResolver<T> resolve(ValueResolvingContext context) throws MuleException {
        return (ParameterResolver)((Function)this.parameterResolverSupplier.get()).apply(context);
    }

    @Override
    public boolean isDynamic() {
        return this.resolver.isDynamic();
    }

    @Override
    public boolean isContent() {
        return this.resolver.isContent();
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolver, (boolean)true, (MuleContext)this.muleContext);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

