/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.error;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.sdk.api.error.ErrorTypeDefinition;

public class JavaErrorModelParser
implements ErrorModelParser {
    private final boolean muleError;
    private final ErrorTypeDefinition<?> errorTypeDefinition;
    private final Class<?> errorTypeDefinitionDeclarationClass;
    private Optional<ErrorModelParser> parent = Optional.empty();

    public JavaErrorModelParser(ErrorTypeDefinition<?> errorTypeDefinition, boolean muleError) {
        this.errorTypeDefinition = errorTypeDefinition;
        this.muleError = muleError;
        this.errorTypeDefinitionDeclarationClass = JavaErrorModelParserUtils.getDeclarationClass(errorTypeDefinition);
    }

    @Override
    public String getType() {
        return this.errorTypeDefinition.getType();
    }

    @Override
    public boolean isMuleError() {
        return this.muleError;
    }

    public void setParent(Optional<ErrorModelParser> parent) {
        this.parent = parent;
    }

    @Override
    public Optional<ErrorModelParser> getParent() {
        return this.parent;
    }

    public ErrorTypeDefinition<?> getErrorTypeDefinition() {
        return this.errorTypeDefinition;
    }

    public Class<?> getErrorTypeDefinitionDeclarationClass() {
        return this.errorTypeDefinitionDeclarationClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaErrorModelParser that = (JavaErrorModelParser)o;
        return Objects.equals(this.errorTypeDefinitionDeclarationClass, that.errorTypeDefinitionDeclarationClass);
    }

    public int hashCode() {
        return Objects.hash(this.errorTypeDefinitionDeclarationClass);
    }
}

