/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataUtils;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.mule.sdk.api.annotation.param.Parameter;

public class SampleDataDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            public void onSource(SourceDeclaration declaration) {
                declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(property -> {
                    SampleData annotation = property.getType().getAnnotation(SampleData.class);
                    if (annotation != null) {
                        declaration.setSampleDataProviderModel(SampleDataDeclarationEnricher.this.createSampleDataModel(annotation, (ExecutableComponentDeclaration)declaration));
                    }
                });
            }

            public void onOperation(OperationDeclaration declaration) {
                declaration.getModelProperty(ImplementingMethodModelProperty.class).ifPresent(property -> {
                    Method method = property.getMethod();
                    SampleData annotation = method.getAnnotation(SampleData.class);
                    if (annotation != null) {
                        declaration.setSampleDataProviderModel(SampleDataDeclarationEnricher.this.createSampleDataModel(annotation, (ExecutableComponentDeclaration)declaration));
                    }
                });
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private SampleDataProviderModel createSampleDataModel(SampleData annotation, ExecutableComponentDeclaration declaration) {
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        for (Binding binding : annotation.bindings()) {
            bindingMap.put(binding.actingParameter(), binding.extractionExpression());
        }
        List allParameters = declaration.getAllParameters();
        Map<String, String> parameterNames = this.getContainerParameterNames(allParameters);
        Class resolverClass = annotation.value();
        SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder propertyBuilder = new SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder(resolverClass);
        ParameterizableTypeWrapper resolverClassWrapper = new ParameterizableTypeWrapper(resolverClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader());
        List<ExtensionParameter> resolverParameters = resolverClassWrapper.getParametersAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        resolverParameters.addAll(resolverClassWrapper.getParametersAnnotatedWith(Parameter.class));
        resolverParameters.forEach(param -> propertyBuilder.withInjectableParameter(param.getName(), param.getType().asMetadataType(), param.isRequired(), bindingMap.getOrDefault(param.getName(), parameterNames.getOrDefault(param.getName(), param.getName()))));
        Reference requiresConfiguration = new Reference((Object)false);
        Reference requiresConnection = new Reference((Object)false);
        this.enrichWithConnection(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConnection.set((Object)true);
        });
        this.enrichWithConfiguration(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConfiguration.set((Object)true);
        });
        declaration.addModelProperty((ModelProperty)propertyBuilder.build());
        return new SampleDataProviderModel(this.getActingParametersModel(resolverParameters, parameterNames, bindingMap), SampleDataUtils.getSampleDataProviderId(resolverClass), ((Boolean)requiresConfiguration.get()).booleanValue(), ((Boolean)requiresConnection.get()).booleanValue());
    }

    private Optional<Field> enrichWithConnection(SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> connectionFields = parameterizableComponent.getAnnotatedFields(Connection.class, org.mule.sdk.api.annotation.param.Connection.class);
        if (!connectionFields.isEmpty()) {
            Field field = connectionFields.get(0).getField().get();
            modelPropertyBuilder.withConnection(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private Optional<Field> enrichWithConfiguration(SampleDataProviderFactoryModelProperty.SampleDataProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> configFields = parameterizableComponent.getAnnotatedFields(Config.class, org.mule.sdk.api.annotation.param.Config.class);
        if (!configFields.isEmpty()) {
            Field field = configFields.get(0).getField().get();
            modelPropertyBuilder.withConfig(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private List<ActingParameterModel> getActingParametersModel(List<ExtensionParameter> parameterDeclarations, Map<String, String> parameterNames, Map<String, String> bindings) {
        return parameterDeclarations.stream().map(extensionParameter -> bindings.containsKey(extensionParameter.getName()) ? new ImmutableActingParameterModel(extensionParameter.getName(), extensionParameter.isRequired(), (String)bindings.get(extensionParameter.getName())) : new ImmutableActingParameterModel(parameterNames.getOrDefault(extensionParameter.getName(), extensionParameter.getName()), extensionParameter.isRequired(), parameterNames.getOrDefault(extensionParameter.getName(), extensionParameter.getName()))).collect(Collectors.toList());
    }

    private Map<String, String> getContainerParameterNames(List<ParameterDeclaration> allParameters) {
        HashMap<String, String> parameterNames = new HashMap<String, String>();
        for (ParameterDeclaration parameterDeclaration : allParameters) {
            parameterNames.put(IntrospectionUtils.getImplementingName(parameterDeclaration), parameterDeclaration.getName());
        }
        return parameterNames;
    }
}

