/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ImmutableClientCredentialsState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.exception.TokenInvalidatedException;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.listener.ClientCredentialsListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class UpdatingClientCredentialsState
implements ClientCredentialsState {
    private final ClientCredentialsOAuthDancer dancer;
    private ClientCredentialsState delegate;
    private boolean invalidated = false;
    private ClientCredentialsListener clientCredentialsListener;

    public UpdatingClientCredentialsState(ClientCredentialsOAuthDancer dancer, ResourceOwnerOAuthContext initialContext, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.dancer = dancer;
        this.updateDelegate(initialContext);
        this.clientCredentialsListener = new ClientCredentialsListener(){

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                UpdatingClientCredentialsState.this.updateDelegate(context);
                onUpdate.accept(context);
            }

            public void onTokenInvalidated() {
                UpdatingClientCredentialsState.this.invalidated = true;
            }
        };
        dancer.addListener(this.clientCredentialsListener);
    }

    private void updateDelegate(ResourceOwnerOAuthContext initialContext) {
        this.delegate = new ImmutableClientCredentialsState(initialContext.getAccessToken(), initialContext.getExpiresIn());
        this.invalidated = false;
    }

    public String getAccessToken() {
        if (this.invalidated) {
            try {
                this.dancer.accessToken().get();
                this.updateDelegate(this.dancer.getContext());
            }
            catch (Exception e) {
                throw new TokenInvalidatedException("Access Token has been invalidated and failed to obtain a new one", e);
            }
        }
        return this.delegate.getAccessToken();
    }

    public Optional<String> getExpiresIn() {
        return this.delegate.getExpiresIn();
    }

    public void deregisterListener() {
        this.dancer.removeListener(this.clientCredentialsListener);
    }
}

