/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.BaseOAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConnectionProvider;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class PlatformManagedOAuthConnectionProviderObjectBuilder<C>
extends BaseOAuthConnectionProviderObjectBuilder<C> {
    private final PlatformManagedOAuthHandler platformHandler;
    private final PlatformManagedOAuthGrantType grantType;
    private final ConfigurationProperties configurationProperties;

    public PlatformManagedOAuthConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, PlatformManagedOAuthGrantType grantType, PlatformManagedOAuthHandler platformHandler, ConfigurationProperties configurationProperties, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(PlatformManagedOAuthConnectionProvider.class, providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
        this.platformHandler = platformHandler;
        this.grantType = grantType;
        this.configurationProperties = configurationProperties;
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ValueResolvingContext context) throws MuleException {
        ConfigurationModel configurationModel = (ConfigurationModel)context.getProperty("Configuration model");
        ResolverSetResult resolverSetResult = this.resolverSet.resolve(context);
        Pair<ConnectionProviderModel, OAuthGrantType> delegateModel = this.getDelegateOAuthConnectionProviderModel(configurationModel);
        String connectionId = (String)resolverSetResult.get("connectionId");
        PlatformManagedOAuthConfig config = PlatformManagedOAuthConfig.from(this.ownerConfigName, connectionId, this.grantType, this.extensionModel, (ConnectionProviderModel)delegateModel.getFirst(), (OAuthGrantType)delegateModel.getSecond(), this.configurationProperties);
        PlatformManagedOAuthConnectionProvider provider = new PlatformManagedOAuthConnectionProvider(config, this.platformHandler, this.reconnectionConfig, this.poolingProfile);
        return new Pair(provider, (Object)resolverSetResult);
    }

    private Pair<ConnectionProviderModel, OAuthGrantType> getDelegateOAuthConnectionProviderModel(ConfigurationModel configurationModel) {
        final Reference authCodePair = new Reference();
        final Reference clientCredentialsPair = new Reference();
        for (final ConnectionProviderModel cpModel : configurationModel.getConnectionProviders()) {
            if (authCodePair.get() != null) break;
            OAuthModelProperty property = cpModel.getModelProperty(OAuthModelProperty.class).orElse(null);
            if (property == null) continue;
            ((OAuthGrantType)property.getGrantTypes().get(0)).accept(new OAuthGrantTypeVisitor(){

                public void visit(AuthorizationCodeGrantType grantType) {
                    authCodePair.set((Object)new Pair((Object)cpModel, (Object)grantType));
                }

                public void visit(ClientCredentialsGrantType grantType) {
                    clientCredentialsPair.set((Object)new Pair((Object)cpModel, (Object)grantType));
                }

                public void visit(PlatformManagedOAuthGrantType grantType) {
                }
            });
        }
        if (authCodePair.get() != null) {
            return (Pair)authCodePair.get();
        }
        return (Pair)clientCredentialsPair.get();
    }
}

