/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;

public final class ParameterAllowedStereotypesDeclarionEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new Enricher().enrich((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private static class Enricher {
        private final Map<StereotypeDefinition, StereotypeModel> stereotypesCache = new HashMap<StereotypeDefinition, StereotypeModel>();
        private String defaultNamespace;

        private Enricher() {
        }

        void enrich(ExtensionDeclaration extension) {
            this.defaultNamespace = extension.getXmlDslModel().getPrefix().toUpperCase();
            final HashMap typesByClassName = new HashMap();
            extension.getTypes().forEach(type -> type.getAnnotation(ClassInformationAnnotation.class).ifPresent(st -> typesByClassName.put(st.getClassname(), type)));
            new IdempotentDeclarationWalker(){

                protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                    declaration.getModelProperty(ImplementingParameterModelProperty.class).ifPresent(param -> declaration.setAllowedStereotypeModels(this.getStereotypes(param.getParameter(), typesByClassName)));
                    declaration.getModelProperty(DeclaringMemberModelProperty.class).ifPresent(field -> declaration.setAllowedStereotypeModels(this.getStereotypes(field.getDeclaringField(), typesByClassName)));
                }
            }.walk(extension);
        }

        private List<StereotypeModel> getStereotypes(AnnotatedElement element, Map<String, ObjectType> typesByClassName) {
            Class<?> paramType;
            Type parameterizedType;
            ConfigReferences references = element.getAnnotation(ConfigReferences.class);
            if (references != null) {
                return Arrays.stream(references.value()).map(ref -> StereotypeModelBuilder.newStereotype((String)ref.name(), (String)ref.namespace()).withParent(MuleStereotypes.CONFIG).build()).collect(Collectors.toList());
            }
            ConfigReference ref2 = element.getAnnotation(ConfigReference.class);
            if (ref2 != null) {
                return Collections.singletonList(StereotypeModelBuilder.newStereotype((String)ref2.name(), (String)ref2.namespace()).withParent(MuleStereotypes.CONFIG).build());
            }
            if (element.getAnnotation(FlowReference.class) != null) {
                return Collections.singletonList(MuleStereotypes.FLOW);
            }
            if (element.getAnnotation(ObjectStoreReference.class) != null) {
                return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
            }
            AllowedStereotypes allowedStereotypes = element.getAnnotation(AllowedStereotypes.class);
            if (allowedStereotypes != null) {
                return Arrays.stream(allowedStereotypes.value()).map(definition -> StereotypeResolver.createCustomStereotype(definition, this.defaultNamespace, this.stereotypesCache)).collect(Collectors.toList());
            }
            if (element instanceof Field) {
                parameterizedType = ((Field)element).getGenericType();
                paramType = ((Field)element).getType();
            } else {
                parameterizedType = ((Parameter)element).getParameterizedType();
                paramType = ((Parameter)element).getType();
            }
            if (ObjectStore.class.isAssignableFrom(paramType)) {
                return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
            }
            if (Collection.class.isAssignableFrom(paramType)) {
                return this.parameterizedTypeAnnotations(typesByClassName, parameterizedType, 0);
            }
            if (Map.class.isAssignableFrom(paramType)) {
                return this.parameterizedTypeAnnotations(typesByClassName, parameterizedType, 1);
            }
            if (paramType.isEnum()) {
                return Collections.emptyList();
            }
            return this.typeToAnnotations(typesByClassName, paramType);
        }

        private List<StereotypeModel> parameterizedTypeAnnotations(Map<String, ObjectType> typesByClassName, Type parameterizedType, int typeArgumentIndex) {
            if (parameterizedType instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments();
                Class mapParamType = actualTypeArguments[typeArgumentIndex] instanceof ParameterizedType ? (Class)((ParameterizedType)actualTypeArguments[typeArgumentIndex]).getRawType() : (actualTypeArguments[typeArgumentIndex] instanceof WildcardType ? Object.class : (Class)actualTypeArguments[typeArgumentIndex]);
                return this.typeToAnnotations(typesByClassName, mapParamType);
            }
            return Collections.emptyList();
        }

        private List<StereotypeModel> typeToAnnotations(Map<String, ObjectType> typesByClassName, Class<?> paramType) {
            if (!typesByClassName.containsKey(paramType.getCanonicalName())) {
                return Collections.emptyList();
            }
            return typesByClassName.get(paramType.getCanonicalName()).getAnnotation(StereotypeTypeAnnotation.class).map(st -> st.getAllowedStereotypes()).orElse(Collections.emptyList());
        }
    }
}

