/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.contributor;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

public class InfrastructureFieldContributor
implements ParameterDeclarerContributor {
    private static final Map<Type, InfrastructureTypeMapping.InfrastructureType> TYPE_MAPPING = (Map)InfrastructureTypeMapping.getMap().entrySet().stream().collect(Collectors.toImmutableMap(entry -> new TypeWrapper((Class)entry.getKey(), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(InfrastructureTypeMapping.class.getClassLoader())), Map.Entry::getValue));

    public static Optional<InfrastructureTypeMapping.InfrastructureType> getInfrastructureType(Type type) {
        return TYPE_MAPPING.entrySet().stream().filter(entry -> ((Type)entry.getKey()).isSameType(type)).map(Map.Entry::getValue).findFirst();
    }

    @Override
    public void contribute(ExtensionParameter parameter, ParameterDeclarer declarer, ParameterDeclarationContext declarationContext) {
        InfrastructureFieldContributor.getInfrastructureType(parameter.getType()).ifPresent(infrastructureType -> {
            if (!StringUtils.isBlank((String)infrastructureType.getName())) {
                declarer.withModelProperty((ModelProperty)new InfrastructureParameterModelProperty(infrastructureType.getSequence()));
                declarer.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                InfrastructureTypeMapping.getQName((String)infrastructureType.getName()).ifPresent(arg_0 -> ((ParameterDeclarer)declarer).withModelProperty(arg_0));
                InfrastructureTypeMapping.getDslConfiguration((String)infrastructureType.getName()).ifPresent(arg_0 -> ((ParameterDeclarer)declarer).withDsl(arg_0));
            }
        });
    }
}

