/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasFunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.NoImplicit;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

final class ConfigModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CONFIGURATION = "Configuration";

    ConfigModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declaration, ExtensionElement extensionElement, ExtensionLoadingContext context) {
        List<ConfigurationElement> configurations = extensionElement.getConfigurations();
        if (configurations.isEmpty()) {
            this.declareConfiguration(declaration, extensionElement, extensionElement, context);
        } else {
            for (ConfigurationElement configuration : configurations) {
                this.declareConfiguration(declaration, extensionElement, configuration, context);
            }
        }
    }

    private void declareConfiguration(ExtensionDeclarer declarer, ExtensionElement extensionType, ComponentElement configType, ExtensionLoadingContext loadingContext) {
        ConfigurationDeclarer configurationDeclarer;
        this.checkConfigurationIsNotAnOperation(extensionType, configType);
        Optional<Configuration> configurationAnnotation = configType.getAnnotation(Configuration.class);
        if (configurationAnnotation.isPresent()) {
            Configuration configuration = configurationAnnotation.get();
            String configName = StringUtils.isBlank((String)configuration.name()) ? "config" : configuration.name();
            configurationDeclarer = declarer.withConfig(configName);
        } else {
            configurationDeclarer = declarer.withConfig("config").describedAs("Default configuration");
        }
        Class<Object> extensionClass = extensionType.getDeclaringClass().orElse(Object.class);
        Class<Object> configClass = configType.getDeclaringClass().orElse(Object.class);
        ClassLoader classLoader = extensionClass.getClassLoader() != null ? extensionClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        TypeAwareConfigurationFactory typeAwareConfigurationFactory = new TypeAwareConfigurationFactory(configClass, classLoader);
        configurationDeclarer.withModelProperty((ModelProperty)new ConfigurationFactoryModelProperty(typeAwareConfigurationFactory)).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(configClass));
        if (configType.isAnnotatedWith(NoImplicit.class)) {
            configurationDeclarer.withModelProperty((ModelProperty)new NoImplicitModelProperty());
        }
        configurationDeclarer.withModelProperty((ModelProperty)new ExtensionTypeDescriptorModelProperty(configType));
        this.loader.parseExternalLibs(configType, (DeclaresExternalLibraries)configurationDeclarer);
        ParameterDeclarationContext context = new ParameterDeclarationContext(CONFIGURATION, (NamedDeclaration)configurationDeclarer.getDeclaration());
        this.loader.getFieldParametersLoader().declare((HasParametersDeclarer)configurationDeclarer, configType.getParameters(), context);
        this.getOperationLoaderDelegate().declareOperations(declarer, (HasOperationDeclarer)configurationDeclarer, configType, loadingContext);
        this.getSourceModelLoaderDelegate().declareMessageSources(declarer, (HasSourceDeclarer)configurationDeclarer, configType, loadingContext);
        this.getFunctionModelLoaderDelegate().declareFunctions(declarer, (HasFunctionDeclarer)configurationDeclarer, configType, loadingContext);
        this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders((HasConnectionProviderDeclarer)configurationDeclarer, configType);
    }

    private void checkConfigurationIsNotAnOperation(ExtensionElement extensionElement, ComponentElement configurationType) {
        ArrayList<OperationContainerElement> allOperations = new ArrayList<OperationContainerElement>();
        allOperations.addAll(extensionElement.getOperationContainers());
        allOperations.addAll(configurationType.getOperationContainers());
        for (OperationContainerElement operationClass : allOperations) {
            if (!configurationType.isAssignableFrom(operationClass) && !configurationType.isAssignableTo(operationClass)) continue;
            throw new IllegalConfigurationModelDefinitionException(String.format("Configuration class '%s' cannot be the same class (nor a derivative) of any operation class '%s", configurationType.getName(), operationClass.getName()));
        }
    }
}

