/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.NotAnInputStreamException;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectableParameterResolver.class);
    private final BindingContext expressionResolvingContext;
    private final ExpressionManager expressionManager;
    private final Map<String, InjectableParameterInfo> injectableParametersMap;

    public InjectableParameterResolver(ParameterizedModel parameterizedModel, ParameterValueResolver parameterValueResolver, ExpressionManager expressionManager, List<InjectableParameterInfo> injectableParameters) {
        this.expressionManager = expressionManager;
        this.injectableParametersMap = this.getInjectableParametersMap(injectableParameters);
        this.expressionResolvingContext = this.createBindingContext(parameterValueResolver, parameterizedModel);
    }

    public Object getInjectableParameterValue(String parameterName) {
        Object parameterValue = null;
        InjectableParameterInfo injectableParameterInfo = this.injectableParametersMap.get(parameterName);
        if (injectableParameterInfo == null) {
            throw new IllegalArgumentException("'" + parameterName + "' is not present in the resolver");
        }
        String extractionExpression = injectableParameterInfo.getExtractionExpression();
        String topLevelRequiredParameter = this.keywordSafeName(ValueProviderUtils.getParameterNameFromExtractionExpression(extractionExpression));
        if (this.expressionResolvingContext.lookup(topLevelRequiredParameter).isPresent()) {
            try {
                parameterValue = this.expressionManager.evaluate("#[" + this.sanitizeExpression(injectableParameterInfo.getExtractionExpression()) + "]", DataType.fromType((Class)JavaTypeUtils.getType((MetadataType)injectableParameterInfo.getType())), this.expressionResolvingContext).getValue();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug(String.format("Transformation of injectable parameter '%s' failed, the same value of the resolution will be used.", parameterName), (Throwable)e);
            }
        } else {
            LOGGER.debug("The parameter: '" + topLevelRequiredParameter + "' on which the extraction expression was to be executed is not present in the context, returning null");
        }
        return parameterValue;
    }

    private Map<String, InjectableParameterInfo> getInjectableParametersMap(List<InjectableParameterInfo> injectableParameters) {
        return injectableParameters.stream().collect(Collectors.toMap(InjectableParameterInfo::getParameterName, injectableParameter -> injectableParameter));
    }

    private BindingContext createBindingContext(ParameterValueResolver parameterValueResolver, ParameterizedModel parameterizedModel) {
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        for (ParameterModel parameterModel : parameterizedModel.getAllParameterModels()) {
            String unaliasedName = IntrospectionUtils.getImplementingName(parameterModel);
            Object value = this.getParameterValueSafely(parameterValueResolver, unaliasedName);
            if (value == null) {
                value = this.getParameterValueSafely(parameterValueResolver, parameterModel.getName());
            }
            if (value == null) continue;
            if (!(value instanceof TypedValue)) {
                String mediaType = (String)parameterModel.getType().getMetadataFormat().getValidMimeTypes().iterator().next();
                try {
                    value = IOUtils.ifInputStream((Object)value, IOUtils::toByteArray);
                }
                catch (NotAnInputStreamException notAnInputStreamException) {
                    // empty catch block
                }
                DataType valueDataType = DataType.builder().type(value.getClass()).mediaType(mediaType).build();
                value = new TypedValue(value, valueDataType);
            }
            bindingContextBuilder.addBinding(this.keywordSafeName(parameterModel.getName()), (TypedValue)value);
        }
        return bindingContextBuilder.build();
    }

    private Object getParameterValueSafely(ParameterValueResolver parameterValueResolver, String parameterName) {
        try {
            return parameterValueResolver.getParameterValue(parameterName);
        }
        catch (ValueResolvingException e) {
            return null;
        }
    }

    private String keywordSafeName(String parameterName) {
        return parameterName + "_";
    }

    private String sanitizeExpression(String extractionExpression) {
        String topLevelParameter = ValueProviderUtils.getParameterNameFromExtractionExpression(extractionExpression);
        return extractionExpression.replaceFirst(topLevelParameter, this.keywordSafeName(topLevelParameter));
    }
}

