/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOutputDeclaration;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverSupplier;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithDeclaringClass;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.metadata.BooleanKeyResolver;
import org.mule.runtime.module.extension.internal.metadata.EnumKeyResolver;
import org.mule.runtime.module.extension.internal.metadata.MetadataScopeAdapter;
import org.mule.runtime.module.extension.internal.metadata.ResolverSupplier;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class DefaultMetadataScopeAdapter
implements MetadataScopeAdapter {
    private Supplier<NullMetadataResolver> nullMetadataResolverSupplier = new NullMetadataResolverSupplier();
    private Supplier<? extends TypeKeysResolver> keysResolver = this.nullMetadataResolverSupplier;
    private Supplier<? extends OutputTypeResolver> outputResolver = this.nullMetadataResolverSupplier;
    private Map<String, Supplier<? extends InputTypeResolver>> inputResolvers = new HashMap<String, Supplier<? extends InputTypeResolver>>();
    private Supplier<? extends AttributesTypeResolver> attributesResolver = this.nullMetadataResolverSupplier;

    public DefaultMetadataScopeAdapter(Type extensionElement, MethodElement operation, OperationDeclaration declaration) {
        operation.getValueFromAnnotation(OutputResolver.class);
        Optional outputResolverDeclaration = operation.getAnnotation(OutputResolver.class);
        Optional<Pair<MetadataKeyId, MetadataType>> keyId = this.locateMetadataKeyId((ComponentDeclaration<? extends ComponentDeclaration>)declaration);
        this.inputResolvers = this.getInputResolvers((ParameterizedDeclaration<? extends BaseDeclaration>)declaration);
        if (outputResolverDeclaration.isPresent() || !this.inputResolvers.isEmpty()) {
            outputResolverDeclaration.ifPresent(resolverDeclaration -> {
                if (!this.hasCustomStaticType((TypedDeclaration)declaration.getOutput())) {
                    this.outputResolver = ResolverSupplier.of(resolverDeclaration.output());
                }
                if (!this.hasCustomStaticType((TypedDeclaration)declaration.getOutputAttributes())) {
                    this.attributesResolver = ResolverSupplier.of(resolverDeclaration.attributes());
                }
            });
            keyId.ifPresent(pair -> {
                this.keysResolver = this.getKeysResolver((MetadataType)pair.getRight(), (MetadataKeyId)pair.getLeft(), () -> this.getCategoryName(this.outputResolver, this.attributesResolver, this.inputResolvers));
            });
        } else {
            this.initializeFromClass(extensionElement, operation, (WithOutputDeclaration)declaration);
        }
    }

    public DefaultMetadataScopeAdapter(Type extensionElement, WithDeclaringClass source, SourceDeclaration sourceDeclaration) {
        this.initializeFromClass(extensionElement, source, (WithOutputDeclaration)sourceDeclaration);
    }

    public DefaultMetadataScopeAdapter(SourceCallbackDeclaration sourceCallbackDeclaration) {
        this.inputResolvers = this.getInputResolvers((ParameterizedDeclaration<? extends BaseDeclaration>)sourceCallbackDeclaration);
    }

    private Map<String, Supplier<? extends InputTypeResolver>> getInputResolvers(ParameterizedDeclaration<? extends BaseDeclaration> declaration) {
        return declaration.getAllParameters().stream().filter(p -> IntrospectionUtils.getAnnotatedElement(p).map(e -> e.isAnnotationPresent(TypeResolver.class)).orElse(false)).filter(p -> !this.hasCustomStaticType((TypedDeclaration)p)).collect(Collectors.toMap(p -> p.getName(), p -> ResolverSupplier.of(IntrospectionUtils.getAnnotatedElement(p).get().getAnnotation(TypeResolver.class).value())));
    }

    private void initializeFromClass(Type extensionType, WithDeclaringClass annotatedType, WithOutputDeclaration declaration) {
        Optional<Class<?>> extensionClass = extensionType.getDeclaringClass();
        Optional<Class<?>> componentClass = annotatedType.getDeclaringClass();
        if (componentClass.isPresent() && extensionClass.isPresent()) {
            MetadataScope scope = IntrospectionUtils.getAnnotation(componentClass.get(), MetadataScope.class);
            MetadataScope metadataScope = scope = scope != null ? scope : IntrospectionUtils.getAnnotation(extensionClass.get(), MetadataScope.class);
            if (scope != null && !this.hasCustomStaticType((TypedDeclaration)declaration.getOutput())) {
                this.keysResolver = ResolverSupplier.of(scope.keysResolver());
                this.outputResolver = ResolverSupplier.of(scope.outputResolver());
                this.attributesResolver = ResolverSupplier.of(scope.attributesResolver());
            }
        }
    }

    private Optional<Pair<MetadataKeyId, MetadataType>> locateMetadataKeyId(ComponentDeclaration<? extends ComponentDeclaration> component) {
        Optional<Pair<MetadataKeyId, MetadataType>> keyId;
        block1: {
            ParameterGroupDeclaration group;
            keyId = component.getAllParameters().stream().map(declaration -> new ImmutablePair(declaration, IntrospectionUtils.getAnnotatedElement(declaration))).filter(p -> ((Optional)p.getRight()).isPresent() && ((AnnotatedElement)((Optional)p.getRight()).get()).isAnnotationPresent(MetadataKeyId.class)).map(p -> new ImmutablePair((Object)((AnnotatedElement)((Optional)p.getRight()).get()).getAnnotation(MetadataKeyId.class), (Object)((ParameterDeclaration)p.getLeft()).getType())).findFirst();
            if (keyId.isPresent()) break block1;
            Iterator iterator = component.getParameterGroups().iterator();
            while (iterator.hasNext() && !(keyId = (group = (ParameterGroupDeclaration)iterator.next()).getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).filter(g -> g.getAnnotatedContainer().isAnnotatedWith(MetadataKeyId.class)).map(g -> new ImmutablePair((Object)g.getContainer().getAnnotation(MetadataKeyId.class), (Object)g.getType().asMetadataType()))).isPresent()) {
            }
        }
        return keyId;
    }

    private Supplier<? extends TypeKeysResolver> getKeysResolver(MetadataType metadataType, MetadataKeyId metadataKeyId, Supplier<String> categoryName) {
        Supplier<Object> keysResolver = metadataKeyId.value().equals(NullMetadataResolver.class) ? (metadataType instanceof BooleanType ? () -> new BooleanKeyResolver((String)categoryName.get()) : (MetadataTypeUtils.isEnum((MetadataType)metadataType) ? () -> new EnumKeyResolver((EnumAnnotation)metadataType.getAnnotation(EnumAnnotation.class).get(), (String)categoryName.get()) : this.nullMetadataResolverSupplier)) : ResolverSupplier.of(metadataKeyId.value());
        return keysResolver;
    }

    private String getCategoryName(Supplier<? extends OutputTypeResolver> outputResolver, Supplier<? extends AttributesTypeResolver> attributesResolver, Map<String, Supplier<? extends InputTypeResolver>> inputResolvers) {
        OutputTypeResolver outputTypeResolver = outputResolver.get();
        if (!(outputTypeResolver instanceof NullMetadataResolver)) {
            return outputTypeResolver.getCategoryName();
        }
        AttributesTypeResolver attributesTypeResolver = attributesResolver.get();
        if (!(attributesTypeResolver instanceof NullMetadataResolver)) {
            return attributesTypeResolver.getCategoryName();
        }
        for (Supplier<? extends InputTypeResolver> supplier : inputResolvers.values()) {
            InputTypeResolver inputTypeResolver = supplier.get();
            if (inputTypeResolver instanceof NullMetadataResolver) continue;
            return inputTypeResolver.getCategoryName();
        }
        throw new IllegalModelDefinitionException("Unable to create Keys Resolver. A Keys Resolver is being defined without defining an Output Resolver, Input Resolver nor Attributes Resolver");
    }

    private boolean hasCustomStaticType(TypedDeclaration declaration) {
        return declaration.getType().getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent();
    }

    @Override
    public boolean isCustomScope() {
        return this.hasOutputResolver() || this.hasInputResolvers();
    }

    @Override
    public boolean hasInputResolvers() {
        return !this.inputResolvers.isEmpty();
    }

    @Override
    public boolean hasOutputResolver() {
        return !(this.outputResolver instanceof NullMetadataResolverSupplier);
    }

    @Override
    public boolean hasAttributesResolver() {
        return !(this.attributesResolver instanceof NullMetadataResolverSupplier);
    }

    @Override
    public Supplier<? extends TypeKeysResolver> getKeysResolver() {
        return this.keysResolver;
    }

    @Override
    public Map<String, Supplier<? extends InputTypeResolver>> getInputResolvers() {
        return this.inputResolvers;
    }

    @Override
    public Supplier<? extends OutputTypeResolver> getOutputResolver() {
        return this.outputResolver;
    }

    @Override
    public Supplier<? extends AttributesTypeResolver> getAttributesResolver() {
        return this.attributesResolver;
    }
}

