/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.config.ExpirableConfigurationProvider;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements ExpirableConfigurationProvider,
ConfigurationParameterValueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigurationProvider.class);
    private final ConfigurationInstanceFactory configurationInstanceFactory;
    private final ResolverSet resolverSet;
    private final ConnectionProviderValueResolver connectionProviderResolver;
    private final ExpirationPolicy expirationPolicy;
    private final Map<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance> cache = new ConcurrentHashMap<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance>();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock cacheReadLock = this.cacheLock.readLock();
    private final Lock cacheWriteLock = this.cacheLock.writeLock();
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;

    public DynamicConfigurationProvider(String name, ExtensionModel extension, ConfigurationModel config, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, ExpirationPolicy expirationPolicy, ReflectionCache reflectionCache, ExpressionManager expressionManager, MuleContext muleContext) {
        super(name, extension, config, muleContext);
        this.configurationInstanceFactory = new ConfigurationInstanceFactory(extension, config, resolverSet, expressionManager, muleContext);
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.resolverSet = resolverSet;
        this.connectionProviderResolver = connectionProviderResolver;
        this.expirationPolicy = expirationPolicy;
    }

    public ConfigurationInstance get(Event event) {
        return (ConfigurationInstance)ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            try (ValueResolvingContext resolvingContext = ValueResolvingContext.builder((CoreEvent)event).withExpressionManager(this.expressionManager).build();){
                ResolverSetResult result = this.resolverSet.resolve(resolvingContext);
                ResolverSetResult providerResult = null;
                if (this.connectionProviderResolver.getResolverSet().isPresent()) {
                    providerResult = this.connectionProviderResolver.getResolverSet().get().resolve(resolvingContext);
                }
                ConfigurationInstance configurationInstance = this.getConfiguration((Pair<ResolverSetResult, ResolverSetResult>)new Pair((Object)result, providerResult), (CoreEvent)event);
                return configurationInstance;
            }
        });
    }

    private ConfigurationInstance getConfiguration(Pair<ResolverSetResult, ResolverSetResult> resolverSetResult, CoreEvent event) throws Exception {
        this.cacheReadLock.lock();
        try {
            ConfigurationInstance configuration = this.cache.computeIfAbsent(resolverSetResult, r -> this.createConfiguration((Pair<ResolverSetResult, ResolverSetResult>)r, event));
            this.updateUsageStatistic(configuration);
            ConfigurationInstance configurationInstance = configuration;
            return configurationInstance;
        }
        catch (WrappingRuntimeException e) {
            throw e.getWrappedException();
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    private void updateUsageStatistic(ConfigurationInstance configuration) {
        MutableConfigurationStats stats = (MutableConfigurationStats)configuration.getStatistics();
        stats.updateLastUsed();
    }

    private ConfigurationInstance createConfiguration(Pair<ResolverSetResult, ResolverSetResult> values, CoreEvent event) {
        LifecycleUtils.assertNotStopping((MuleContext)this.muleContext, (String)"Mule is shutting down... Cannot create new dynamic configurations");
        ResolverSetResult connectionProviderValues = (ResolverSetResult)values.getSecond();
        try {
            ConfigurationInstance configuration = connectionProviderValues != null ? this.configurationInstanceFactory.createConfiguration(this.getName(), (ResolverSetResult)values.getFirst(), event, this.connectionProviderResolver, connectionProviderValues) : this.configurationInstanceFactory.createConfiguration(this.getName(), (ResolverSetResult)values.getFirst(), event, Optional.ofNullable(this.connectionProviderResolver));
            this.registerConfiguration(configuration);
            return configuration;
        }
        catch (MuleException e) {
            throw new WrappingRuntimeException((Exception)((Object)e));
        }
    }

    @Override
    protected void registerConfiguration(ConfigurationInstance configuration) {
        try {
            ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
                if (this.lifecycleManager.isPhaseComplete("initialise")) {
                    try {
                        LifecycleUtils.initialiseIfNeeded((Object)configuration, (boolean)true, (MuleContext)this.muleContext);
                    }
                    catch (Exception e) {
                        LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
                        throw e;
                    }
                }
                if (this.lifecycleManager.isPhaseComplete("start")) {
                    try {
                        this.startConfig(configuration);
                    }
                    catch (Exception e) {
                        try {
                            LifecycleUtils.stopIfNeeded((Object)configuration);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Exception while stopping " + configuration.toString(), (Throwable)e);
                        }
                        LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
                        throw e;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not register configuration of key " + this.getName())), (Throwable)e);
        }
        super.registerConfiguration(configuration);
    }

    public List<ConfigurationInstance> getExpired() {
        this.cacheWriteLock.lock();
        try {
            List list = (List)this.cache.entrySet().stream().filter(entry -> this.isExpired((ConfigurationInstance)entry.getValue())).map(entry -> {
                this.cache.remove(entry.getKey());
                this.unRegisterConfiguration((ConfigurationInstance)entry.getValue());
                return (ConfigurationInstance)entry.getValue();
            }).collect(Collectors.toImmutableList());
            return list;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private boolean isExpired(ConfigurationInstance configuration) {
        ConfigurationStats stats = configuration.getStatistics();
        return stats.getActiveComponents() == 0 && this.expirationPolicy.isExpired(stats.getLastUsedMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doInitialise() {
        try {
            LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)this.connectionProviderResolver, (MuleContext)this.muleContext);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded((Object)this.connectionProviderResolver);
    }

    public boolean isDynamic() {
        return true;
    }

    public Set<Value> getConfigValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> new ValueProviderMediator<ConfigurationModel>(this.getConfigurationModel(), () -> this.muleContext, () -> this.reflectionCache).getValues(parameterName, new ResolverSetBasedParameterResolver(this.resolverSet, (ParameterizedModel)this.getConfigurationModel(), this.reflectionCache, this.expressionManager)), this.getExtensionModel());
    }

    public Set<Value> getConnectionValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> {
            ConnectionProviderModel connectionProviderModel = this.getConnectionProviderModel().orElseThrow(() -> new ValueResolvingException("Internal Error. Unable to resolve values because the service is unable to get the connection model", "UNKNOWN"));
            ResolverSet resolverSet = this.connectionProviderResolver.getResolverSet().orElseThrow(() -> new ValueResolvingException("Internal Error. Unable to resolve values because of the service is unable to retrieve connection parameters", "UNKNOWN"));
            return new ValueProviderMediator<ConnectionProviderModel>(connectionProviderModel, () -> this.muleContext, () -> this.reflectionCache).getValues(parameterName, new ResolverSetBasedParameterResolver(resolverSet, (ParameterizedModel)connectionProviderModel, this.reflectionCache, this.expressionManager));
        }, this.getExtensionModel());
    }

    private Optional<ConnectionProviderModel> getConnectionProviderModel() {
        return this.connectionProviderResolver.getObjectBuilder().filter(ob -> ob instanceof ConnectionProviderObjectBuilder).map(ob -> ((ConnectionProviderObjectBuilder)ob).providerModel);
    }

    private static class WrappingRuntimeException
    extends RuntimeException {
        private final Exception wrappedException;

        public WrappingRuntimeException(Exception e) {
            super(e);
            this.wrappedException = e;
        }

        public Exception getWrappedException() {
            return this.wrappedException;
        }
    }
}

