/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandlerFactory;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.DefaultExceptionHandlerFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleExtensionAnnotationParser {
    private static final Logger logger = LoggerFactory.getLogger(MuleExtensionAnnotationParser.class);

    public static String getMemberName(BaseDeclaration<?> declaration, String defaultName) {
        return declaration.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField().getName()).orElse(defaultName);
    }

    public static Extension getExtension(Class<?> extensionType) {
        try {
            Extension extension = extensionType.getAnnotation(Extension.class);
            Preconditions.checkState((extension != null ? 1 : 0) != 0, (String)String.format("%s is not a Mule extension since it's not annotated with %s", extensionType.getName(), Extension.class.getName()));
            return extension;
        }
        catch (Exception e) {
            logger.error(String.format("%s getting '@Extension' annotation from %s", e.getClass().getName(), extensionType.getName()), (Throwable)e);
            throw e;
        }
    }

    public static <T extends Annotation> List<T> parseRepeatableAnnotation(Class<?> extensionType, Class<T> annotation, Function<Annotation, T[]> containerConsumer) {
        T singleDeclaration;
        Annotation container;
        ImmutableList annotationDeclarations = ImmutableList.of();
        Repeatable repeatableContainer = annotation.getAnnotation(Repeatable.class);
        if (repeatableContainer != null && (container = IntrospectionUtils.getAnnotation(extensionType, repeatableContainer.value())) != null) {
            annotationDeclarations = ImmutableList.copyOf((Object[])containerConsumer.apply(container));
        }
        if ((singleDeclaration = IntrospectionUtils.getAnnotation(extensionType, annotation)) != null) {
            annotationDeclarations = ImmutableList.of(singleDeclaration);
        }
        return annotationDeclarations;
    }

    public static <T extends Annotation> List<AnnotationValueFetcher<T>> parseRepeatableAnnotation(Type extensionType, Class<T> annotation, Function<Annotation, T[]> containerConsumer) {
        Optional<AnnotationValueFetcher<T>> singleDeclaration;
        Optional<AnnotationValueFetcher<? extends Annotation>> container;
        Object annotationDeclarations = ImmutableList.of();
        Repeatable repeatableContainer = annotation.getAnnotation(Repeatable.class);
        if (repeatableContainer != null && (container = extensionType.getValueFromAnnotation(repeatableContainer.value())).isPresent()) {
            annotationDeclarations = container.get().getInnerAnnotations(containerConsumer);
        }
        if ((singleDeclaration = extensionType.getValueFromAnnotation(annotation)).isPresent()) {
            annotationDeclarations = Collections.singletonList(singleDeclaration.get());
        }
        return annotationDeclarations;
    }

    public static List<String> getParamNames(Method method) {
        ImmutableList.Builder paramNames = ImmutableList.builder();
        for (Parameter parameter : method.getParameters()) {
            Alias alias = parameter.getAnnotation(Alias.class);
            if (alias != null) {
                paramNames.add((Object)alias.value());
                continue;
            }
            paramNames.add((Object)parameter.getName());
        }
        return paramNames.build();
    }

    public static Map<Class<? extends Annotation>, Annotation> toMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            map.put(ClassUtils.resolveAnnotationClass((Annotation)annotation), annotation);
        }
        return map;
    }

    private static void doParseLayoutAnnotations(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        Text textAnnotation;
        Password passwordAnnotation = annotatedElement.getAnnotation(Password.class);
        if (passwordAnnotation != null) {
            builder.asPassword();
        }
        if ((textAnnotation = annotatedElement.getAnnotation(Text.class)) != null) {
            builder.asText();
        }
    }

    private static void doParseLayoutAnnotations(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        Optional<Text> textAnnotation;
        Optional<Password> passwordAnnotation = annotatedElement.getAnnotation(Password.class);
        if (passwordAnnotation.isPresent()) {
            builder.asPassword();
        }
        if ((textAnnotation = annotatedElement.getAnnotation(Text.class)).isPresent()) {
            builder.asText();
        }
    }

    private static void parsePlacementAnnotation(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        Optional<Placement> placementAnnotation = annotatedElement.getAnnotation(Placement.class);
        if (placementAnnotation.isPresent()) {
            Placement placement = placementAnnotation.get();
            builder.order(placement.order()).tabName(placement.tab());
        }
    }

    private static void parsePlacementAnnotation(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        Placement placement = annotatedElement.getAnnotation(Placement.class);
        if (placement != null) {
            builder.order(placement.order()).tabName(placement.tab());
        }
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(AnnotatedElement annotatedElement) {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(annotatedElement, LayoutModel.builder());
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(WithAnnotations annotatedElement) {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(annotatedElement, LayoutModel.builder());
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(WithAnnotations annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        if (MuleExtensionAnnotationParser.isDisplayAnnotationPresent(annotatedElement)) {
            MuleExtensionAnnotationParser.doParseLayoutAnnotations(annotatedElement, builder);
            MuleExtensionAnnotationParser.parsePlacementAnnotation(annotatedElement, builder);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    public static Optional<LayoutModel> parseLayoutAnnotations(AnnotatedElement annotatedElement, LayoutModel.LayoutModelBuilder builder) {
        if (MuleExtensionAnnotationParser.isDisplayAnnotationPresent(annotatedElement)) {
            MuleExtensionAnnotationParser.doParseLayoutAnnotations(annotatedElement, builder);
            MuleExtensionAnnotationParser.parsePlacementAnnotation(annotatedElement, builder);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private static boolean isDisplayAnnotationPresent(AnnotatedElement annotatedElement) {
        List<Class> displayAnnotations = Arrays.asList(Password.class, Text.class, Placement.class);
        return displayAnnotations.stream().anyMatch(annotation -> annotatedElement.getAnnotation(annotation) != null);
    }

    private static boolean isDisplayAnnotationPresent(WithAnnotations annotatedElement) {
        List<Class> displayAnnotations = Arrays.asList(Password.class, Text.class, Placement.class);
        return displayAnnotations.stream().anyMatch(annotation -> annotatedElement.getAnnotation(annotation) != null);
    }

    static Optional<ExceptionHandlerFactory> getExceptionEnricherFactory(WithAnnotations element) {
        if (element.isAnnotatedWith(OnException.class)) {
            Type classValue = element.getValueFromAnnotation(OnException.class).get().getClassValue(OnException::value);
            return classValue.getDeclaringClass().map(clazz -> new DefaultExceptionHandlerFactory((Class<? extends ExceptionHandler>)clazz));
        }
        return Optional.empty();
    }
}

