/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import javax.lang.model.element.VariableElement;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterElement;
import org.mule.runtime.module.extension.internal.loader.java.type.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.springframework.core.ResolvableType;

public final class ParameterWrapper
implements ParameterElement {
    private final Parameter parameter;
    private final Method owner;
    private final int index;
    private final ClassTypeLoader typeLoader;

    public ParameterWrapper(Method owner, int index, ClassTypeLoader typeLoader) {
        this.index = index;
        this.typeLoader = typeLoader;
        this.parameter = owner.getParameters()[index];
        this.owner = owner;
    }

    @Override
    public Optional<Parameter> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    @Override
    public TypeWrapper getType() {
        return new ParameterTypeWrapper(ResolvableType.forMethodParameter((Method)this.owner, (int)this.index), this.typeLoader);
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.parameter.getAnnotation(annotationClass));
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.parameter, this.typeLoader)) : Optional.empty();
    }

    @Override
    public String getAlias() {
        return InfrastructureTypeMapping.getInfrastructureType(this.getType()).map(InfrastructureTypeMapping.InfrastructureType::getName).orElse(ParameterElement.super.getAlias());
    }

    @Override
    public String getName() {
        return this.parameter.getName();
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Method: '%s'", this.owner.getName());
    }

    @Override
    public Optional<VariableElement> getElement() {
        return Optional.empty();
    }
}

