/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.AbstractReturnDelegate;

final class TargetReturnDelegate
extends AbstractReturnDelegate {
    private final ExpressionManager expressionManager;
    private final String target;
    private final String targetValue;
    private final StreamingManager streamingManager;

    TargetReturnDelegate(String target, String targetValue, ComponentModel componentModel, ExpressionManager expressionManager, CursorProviderFactory cursorProviderFactory, MuleContext muleContext, StreamingManager streamingManager) {
        super(componentModel, cursorProviderFactory, muleContext);
        this.expressionManager = expressionManager;
        this.target = target;
        this.targetValue = targetValue;
        this.streamingManager = streamingManager;
    }

    @Override
    public CoreEvent asReturnValue(Object value, ExecutionContextAdapter operationContext) {
        CoreEvent event = operationContext.getEvent();
        TypedValue typedValue = this.expressionManager.evaluate(this.targetValue, BindingContextUtils.getTargetBindingContext((Message)this.toMessage(value, operationContext)));
        TypedValue managedTypedValue = StreamingUtils.updateTypedValueForStreaming((TypedValue)typedValue, (CoreEvent)event, (StreamingManager)this.streamingManager);
        return CoreEvent.builder((CoreEvent)event).securityContext(operationContext.getSecurityContext()).addVariable(this.target, managedTypedValue.getValue(), managedTypedValue.getDataType()).build();
    }
}

