/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.execution.InterceptableOperationExecutorWrapper;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReactiveOperationExecutionWrapper;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;

public final class OperationExecutorFactoryWrapper<T extends ComponentModel>
implements ComponentExecutorFactory<T>,
OperationArgumentResolverFactory<T> {
    private final ComponentExecutorFactory delegate;
    private final List<Interceptor> interceptors;

    public OperationExecutorFactoryWrapper(ComponentExecutorFactory<T> delegate, List<Interceptor> interceptors) {
        this.delegate = delegate;
        this.interceptors = interceptors;
    }

    public ComponentExecutor<T> createExecutor(T componentModel, Map<String, Object> parameters) {
        ComponentExecutor executor = this.delegate.createExecutor(componentModel, parameters);
        if (this.isJavaNonBlocking(componentModel, executor)) {
            executor = new ReactiveOperationExecutionWrapper(executor);
        }
        executor = new InterceptableOperationExecutorWrapper(executor, this.interceptors);
        return executor;
    }

    private boolean isJavaNonBlocking(T componentModel, ComponentExecutor<T> executor) {
        if (componentModel instanceof OperationModel && !((OperationModel)componentModel).isBlocking()) {
            return executor instanceof ReflectiveMethodOperationExecutor;
        }
        return componentModel instanceof ConstructModel;
    }

    @Override
    public Function<ExecutionContext<T>, Map<String, Object>> createArgumentResolver(T componentModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)this.delegate).createArgumentResolver(componentModel) : ec -> Collections.emptyMap();
    }
}

