/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import jakarta.inject.Provider;
import java.util.Optional;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.loader.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultImplicitConnectionProviderFactory<T>
implements ImplicitConnectionProviderFactory {
    private final ExtensionModel extensionModel;
    private final ExpressionManager expressionManager;
    private final ArtifactEncoding artifactEncoding;
    private final MuleContext muleContext;
    private Provider<ResolverSet> resolverSetProvider;
    private ConnectionProviderModel connectionProviderModel = null;
    private ResolverSet resolverSet = null;

    public DefaultImplicitConnectionProviderFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, ArtifactEncoding artifactEncoding, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.artifactEncoding = artifactEncoding;
        this.muleContext = muleContext;
        this.expressionManager = expressionManager;
        this.resolverSetProvider = () -> {
            DefaultImplicitConnectionProviderFactory defaultImplicitConnectionProviderFactory = this;
            synchronized (defaultImplicitConnectionProviderFactory) {
                if (this.resolverSet == null) {
                    this.connectionProviderModel = (ConnectionProviderModel)ExtensionModelUtils.getFirstImplicit(MuleExtensionUtils.getAllConnectionProviders(extensionModel, configurationModel));
                    if (this.connectionProviderModel == null) {
                        throw new IllegalStateException(String.format("Configuration '%s' of extension '%s' does not define a connection provider and none can be created automatically. Please define one.", configurationModel.getName(), extensionModel.getName()));
                    }
                    this.resolverSet = ImplicitObjectUtils.buildImplicitResolverSet((ParameterizedModel)this.connectionProviderModel, reflectionCache, expressionManager, artifactEncoding, muleContext);
                    this.resolverSetProvider = () -> this.resolverSet;
                }
                return this.resolverSet;
            }
        };
    }

    @Override
    public Pair<ConnectionProvider<T>, ResolverSetResult> createImplicitConnectionProvider(String configName, CoreEvent event) {
        ResolverSet resolverSet = (ResolverSet)this.resolverSetProvider.get();
        DefaultConnectionProviderObjectBuilder builder = new DefaultConnectionProviderObjectBuilder(this.connectionProviderModel, resolverSet, this.extensionModel, this.expressionManager, this.muleContext.getErrorTypeRepository(), this.artifactEncoding, this.muleContext.getInjector(), this.muleContext.getExecutionClassLoader());
        builder.setOwnerConfigName(configName);
        ValueResolvingContext ctx = ValueResolvingContext.builder(event, this.expressionManager).build();
        try {
            Pair pair = (Pair)builder.build(ctx);
            if (ctx != null) {
                ctx.close();
            }
            return pair;
        }
        catch (Throwable throwable) {
            try {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public boolean isDynamic() {
        return ((ResolverSet)this.resolverSetProvider.get()).isDynamic();
    }

    @Override
    public Optional<ResolverSet> getResolverSet() {
        return Optional.of((ResolverSet)this.resolverSetProvider.get());
    }
}

