/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.params;

import java.util.function.Function;
import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.FileStoreCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.object.FileStoreCursorIteratorConfig;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.internal.streaming.NullCursorProviderFactory;
import org.mule.runtime.extension.api.client.params.ComponentParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.params.BaseParameterizer;

public abstract class BaseComponentParameterizer<T extends ComponentParameterizer>
extends BaseParameterizer<T>
implements ComponentParameterizer<T> {
    private static final CursorProviderFactory NULL_CURSOR_PROVIDER_FACTORY = new NullCursorProviderFactory();
    private String configRef;
    private Function<StreamingManager, CursorProviderFactory> cursorProviderFunction = sm -> NULL_CURSOR_PROVIDER_FACTORY;
    private RetryPolicyTemplate retryPolicyTemplate = new NoRetryPolicyTemplate();

    public T withConfigRef(String configRef) {
        this.configRef = configRef;
        return (T)this;
    }

    public T withSimpleReconnection(int frequency, int maxAttempts) {
        this.retryPolicyTemplate = new SimpleRetryPolicyTemplate((long)frequency, maxAttempts);
        return (T)this;
    }

    public T reconnectingForever(int frequency) {
        this.withSimpleReconnection(frequency, -1);
        return (T)this;
    }

    public T withDefaultRepeatableStreaming() {
        this.cursorProviderFunction = sm -> sm.forBytes().getDefaultCursorProviderFactory();
        return (T)this;
    }

    public T withInMemoryRepeatableStreaming(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxBufferSize) {
        this.cursorProviderFunction = sm -> sm.forBytes().getInMemoryCursorProviderFactory(new InMemoryCursorStreamConfig(initialBufferSize, bufferSizeIncrement, maxBufferSize, false));
        return (T)this;
    }

    public T withFileStoreRepeatableStreaming(DataSize maxInMemorySize) {
        this.cursorProviderFunction = sm -> sm.forBytes().getFileStoreCursorStreamProviderFactory(new FileStoreCursorStreamConfig(maxInMemorySize, false));
        return (T)this;
    }

    public T withDefaultRepeatableIterables() {
        this.cursorProviderFunction = sm -> sm.forObjects().getDefaultCursorProviderFactory();
        return (T)this;
    }

    public T withInMemoryRepeatableIterables(int initialBufferSize, int bufferSizeIncrement, int maxBufferSize) {
        this.cursorProviderFunction = sm -> sm.forObjects().getInMemoryCursorProviderFactory(new InMemoryCursorIteratorConfig(initialBufferSize, bufferSizeIncrement, maxBufferSize));
        return (T)this;
    }

    public T withFileStoreRepeatableIterables(int maxInMemoryInstances) {
        this.cursorProviderFunction = sm -> sm.forObjects().getFileStoreCursorIteratorProviderFactory(new FileStoreCursorIteratorConfig(maxInMemoryInstances));
        return (T)this;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public <T> CursorProviderFactory<T> getCursorProviderFactory(StreamingManager streamingManager) {
        return this.cursorProviderFunction.apply(streamingManager);
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }
}

