/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ValueResolverNotFoundException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetBasedParameterResolver
implements ParameterValueResolver {
    private final ResolverSet resolverSet;
    private final ParameterizedModel parameterizedModel;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private final Optional<ConfigurationInstance> configurationInstance;

    public ResolverSetBasedParameterResolver(ResolverSet resolverSet, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache, ExpressionManager expressionManager, Optional<ConfigurationInstance> configurationInstance) {
        this.resolverSet = resolverSet;
        this.parameterizedModel = parameterizedModel;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.configurationInstance = configurationInstance;
    }

    public ResolverSetBasedParameterResolver(ResolverSet resolverSet, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache, ExpressionManager expressionManager) {
        this(resolverSet, parameterizedModel, reflectionCache, expressionManager, Optional.empty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getParameterValue(String paramName) throws ValueResolvingException {
        try (ValueResolvingContext ctx = this.buildResolvingContext();){
            ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get(paramName);
            if (valueResolver != null) {
                Object obj = valueResolver.resolve(ctx);
                return obj;
            }
            Object object = this.resolveFromParameterGroup(paramName);
            return object;
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException(String.format("Error occurred trying to resolve value for the parameter [%s]", paramName), e);
        }
    }

    protected Object resolveFromParameterGroup(String parameterName) throws ValueResolvingException, MuleException {
        Optional<ValueResolver<?>> paramGroupValueResolver = this.getParameterGroupValueResolver(parameterName);
        if (paramGroupValueResolver.isPresent()) {
            ValueResolver<?> paramGroup = paramGroupValueResolver.get();
            return paramGroup.isDynamic() ? this.resolveDynamicGroup(parameterName, paramGroup) : this.resolveStaticGroup(parameterName, paramGroup);
        }
        throw new ValueResolverNotFoundException(String.format("An error occurred trying to resolve the parameter [%s]", parameterName));
    }

    private Optional<? extends ValueResolver<?>> getParameterGroupValueResolver(String parameterName) {
        Map<String, String> showInDslParameters = IntrospectionUtils.getShowInDslParameters(this.parameterizedModel);
        String parameterGroupName = showInDslParameters.get(parameterName);
        ValueResolver<?> valueResolver = null;
        if (parameterGroupName != null) {
            valueResolver = this.resolverSet.getResolvers().get(parameterGroupName);
        }
        return Optional.ofNullable(valueResolver);
    }

    private Object resolveStaticGroup(String parameterName, ValueResolver<?> paramGroup) throws MuleException, ValueResolvingException {
        try (ValueResolvingContext context = this.buildResolvingContext();){
            Object object = new ObjectBasedParameterValueResolver(paramGroup.resolve(context), this.parameterizedModel, this.reflectionCache).getParameterValue(parameterName);
            return object;
        }
    }

    private Object resolveDynamicGroup(String parameterName, ValueResolver<?> paramGroup) throws ValueResolvingException {
        if (paramGroup instanceof ParameterValueResolver) {
            return ((ParameterValueResolver)((Object)paramGroup)).getParameterValue(parameterName);
        }
        throw new ValueResolvingException(String.format("An error occurred trying to resolve the parameter [%s]", parameterName));
    }

    private ValueResolvingContext buildResolvingContext() {
        return ValueResolvingContext.builder(MuleExtensionUtils.getInitialiserEvent()).withConfig(this.configurationInstance).withExpressionManager(this.expressionManager).build();
    }

    @Override
    public Map<String, ValueResolver<? extends Object>> getParameters() {
        return Collections.unmodifiableMap(this.resolverSet.getResolvers());
    }
}

