/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.loader.parser.FieldValueProviderModelParser;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaValueProviderModelParser;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.values.FieldValues;
import org.mule.sdk.api.annotation.values.FieldsValues;

public class JavaFieldValueProviderModelParser
extends JavaValueProviderModelParser
implements FieldValueProviderModelParser {
    private final List<String> targetSelectors;

    public static List<FieldValueProviderModelParser> getParserFromFieldValues(ExtensionParameter parameter, ClassTypeLoader typeLoader) {
        ArrayList<FieldValueProviderModelParser> fieldValuesList = new ArrayList<FieldValueProviderModelParser>();
        parameter.getValueFromAnnotation(FieldsValues.class).map(fieldsValues -> fieldsValues.getInnerAnnotations(FieldsValues::value)).ifPresent(fetchers -> fetchers.stream().map(fetcher -> JavaFieldValueProviderModelParser.getParserFromFetcher(fetcher, typeLoader)).forEach(mp -> mp.ifPresent(fieldValuesList::add)));
        parameter.getValueFromAnnotation(FieldValues.class).flatMap(fetcher -> JavaFieldValueProviderModelParser.getParserFromFetcher(fetcher, typeLoader)).ifPresent(fieldValuesList::add);
        return fieldValuesList;
    }

    private static Optional<JavaFieldValueProviderModelParser> getParserFromFetcher(AnnotationValueFetcher<FieldValues> valueFetcher, ClassTypeLoader typeLoader) {
        Optional<Class<?>> value = valueFetcher.getClassValue(FieldValues::value).getDeclaringClass();
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JavaFieldValueProviderModelParser(valueFetcher.getArrayValue(FieldValues::targetSelectors), value.get(), valueFetcher.getBooleanValue(FieldValues::open), JavaFieldValueProviderModelParser.getBindingsMapFromFetcher(valueFetcher.getInnerAnnotations(FieldValues::bindings)), typeLoader));
    }

    private static Map<String, String> getBindingsMapFromFetcher(List<AnnotationValueFetcher<Binding>> annotationValueFetcher) {
        return annotationValueFetcher.stream().collect(Collectors.toMap(fetcher -> fetcher.getStringValue(Binding::actingParameter), fetcher -> fetcher.getStringValue(Binding::extractionExpression)));
    }

    public JavaFieldValueProviderModelParser(List<String> targetSelectors, Class<?> clazz, boolean isOpen, Map<String, String> bindingsMap, ClassTypeLoader typeLoader) {
        super(clazz, isOpen, bindingsMap, Optional.empty(), typeLoader, false);
        this.targetSelectors = targetSelectors;
    }

    public List<String> getTargetSelectors() {
        return this.targetSelectors;
    }
}

