/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.data.sample;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.util.InjectableParameterResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDataProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataProviderFactory.class);
    private final SampleDataProviderFactoryModelProperty factoryModelProperty;
    private final ParameterValueResolver parameterValueResolver;
    private final Supplier<Object> connectionSupplier;
    private final Supplier<Object> configurationSupplier;
    private final Field connectionField;
    private final Field configField;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private final Injector injector;
    private final ParameterizedModel parameterizedModel;

    public SampleDataProviderFactory(SampleDataProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Field connectionField, Field configField, ReflectionCache reflectionCache, ExpressionManager expressionManager, Injector injector, ParameterizedModel parameterizedModel) {
        this.factoryModelProperty = factoryModelProperty;
        this.parameterValueResolver = parameterValueResolver;
        this.connectionSupplier = connectionSupplier;
        this.configurationSupplier = configurationSupplier;
        this.connectionField = connectionField;
        this.configField = configField;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.injector = injector;
        this.parameterizedModel = parameterizedModel;
    }

    <T, A> SampleDataProvider<T, A> createSampleDataProvider() throws SampleDataException {
        Class providerClass = this.factoryModelProperty.getSampleDataProviderClass();
        try {
            SampleDataProvider resolver = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            LifecycleUtils.initialiseIfNeeded(resolver, (Injector)this.injector);
            InjectableParameterResolver injectableParameterResolver = new InjectableParameterResolver(this.parameterizedModel, this.parameterValueResolver, (MuleExpressionLanguage)this.expressionManager, this.factoryModelProperty.getInjectableParameters());
            this.injectProviderFields(resolver, injectableParameterResolver);
            if (this.factoryModelProperty.usesConnection()) {
                Object connection;
                try {
                    connection = this.connectionSupplier.get();
                }
                catch (Exception e) {
                    throw new SampleDataException("Failed to establish connection: " + e.getMessage(), "CONNECTION_FAILURE", (Throwable)e);
                }
                if (connection == null) {
                    throw new SampleDataException("The sample data provider requires a connection and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, connection, this.connectionField);
            }
            if (this.factoryModelProperty.usesConfig()) {
                Object config = this.configurationSupplier.get();
                if (config == null) {
                    throw new SampleDataException("The sample data provider requires a configuration and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, config, this.configField);
            }
            return resolver;
        }
        catch (SampleDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampleDataException("An error occurred trying to create a SampleDataProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private void injectProviderFields(SampleDataProvider resolver, InjectableParameterResolver resolvedParameters) throws SampleDataException {
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (InjectableParameterInfo injectableParam : this.factoryModelProperty.getInjectableParameters()) {
            String parameterName = injectableParam.getParameterName();
            Object parameterValue = resolvedParameters.getInjectableParameterValue(injectableParam.getParameterName());
            if (parameterValue != null) {
                IntrospectionUtils.setValueIntoField(resolver, parameterValue, parameterName, this.reflectionCache);
                continue;
            }
            if (!injectableParam.isRequired()) continue;
            missingParameters.add(parameterName);
        }
        if (!missingParameters.isEmpty()) {
            throw new SampleDataException("Unable to retrieve Sample Data. There are missing required parameters for the resolution: " + String.valueOf(missingParameters), "MISSING_REQUIRED_PARAMETERS");
        }
    }
}

