/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.value.SdkValueAdapter;
import org.mule.sdk.api.values.ValueProvider;

public class SdkValueProviderAdapter
implements org.mule.runtime.extension.api.values.ValueProvider,
MuleContextAware,
Initialisable {
    private final ValueProvider valueProvider;
    private MuleContext muleContext;

    public SdkValueProviderAdapter(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public Set<Value> resolve() throws ValueResolvingException {
        try {
            Set values = this.valueProvider.resolve().stream().map(SdkValueAdapter::new).collect(Collectors.toCollection(LinkedHashSet::new));
            return Collections.unmodifiableSet(values);
        }
        catch (org.mule.sdk.api.values.ValueResolvingException e) {
            throw new ValueResolvingException(e.getMessage(), e.getFailureCode(), e.getCause());
        }
    }

    public String getId() {
        return this.valueProvider.getId();
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.valueProvider, (MuleContext)this.muleContext);
    }
}

