/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.oauth.client.api.AuthorizationCodeOAuthDancer;
import org.mule.oauth.client.api.AuthorizationCodeRequest;
import org.mule.oauth.client.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.oauth.client.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.api.listener.AuthorizationCodeListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.module.extension.api.runtime.connectivity.oauth.ImmutableAuthCodeRequest;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.LazyLookup;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.store.LazyObjectStoreToMapAdapter;
import org.mule.runtime.oauth.api.OAuthService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class AuthorizationCodeOAuthHandler
extends OAuthHandler<AuthorizationCodeOAuthDancer> {
    private static final String DANCE_CALLBACK_EVENT_KEY = "event";
    @Inject
    private ArtifactEncoding artifactEncoding;
    @Inject
    private Registry registry;
    protected LazyValue<HttpService> httpService;
    private boolean forceInvalidateStatusRetrieval;

    public AuthorizationCodeOAuthDancer register(AuthorizationCodeConfig config) {
        return this.register(config, Collections.emptyList());
    }

    public AuthorizationCodeOAuthDancer register(AuthorizationCodeConfig config, List<AuthorizationCodeListener> listeners) {
        return (AuthorizationCodeOAuthDancer)this.dancers.computeIfAbsent(config.getOwnerConfigName(), k -> this.createDancer(config, listeners));
    }

    public void refreshToken(String ownerConfigName, String resourceOwnerId) {
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)this.dancers.get(ownerConfigName);
        try {
            dancer.refreshToken(resourceOwnerId).get();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not refresh token for resourceOwnerId '%s' using config '%s'", resourceOwnerId, ownerConfigName)), (Throwable)e);
        }
    }

    public Optional<ResourceOwnerOAuthContext> getOAuthContext(AuthorizationCodeConfig config) {
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)this.dancers.get(config.getOwnerConfigName());
        if (dancer == null) {
            return Optional.empty();
        }
        ResourceOwnerOAuthContext contextForResourceOwner = dancer.getContextForResourceOwner(config.getResourceOwnerId());
        if (contextForResourceOwner == null || contextForResourceOwner.getAccessToken() == null) {
            return Optional.empty();
        }
        return Optional.of(contextForResourceOwner);
    }

    public void invalidate(String ownerConfigName, String resourceOwnerId) {
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)this.dancers.get(ownerConfigName);
        if (dancer == null) {
            return;
        }
        dancer.invalidateContext(resourceOwnerId, this.forceInvalidateStatusRetrieval);
    }

    protected void setForceInvalidateStatusRetrieval(boolean forceInvalidateStatusRetrieval) {
        this.forceInvalidateStatusRetrieval = forceInvalidateStatusRetrieval;
    }

    private AuthorizationCodeOAuthDancer createDancer(AuthorizationCodeConfig config, List<AuthorizationCodeListener> listeners) throws MuleException {
        HttpServer httpServer;
        Preconditions.checkArgument((listeners != null ? 1 : 0) != 0, (String)"listeners cannot be null");
        org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder dancerBuilder = ((OAuthService)this.getOAuthService().get()).authorizationCodeGrantTypeDancerBuilder(this.lockFactory, new LazyObjectStoreToMapAdapter(() -> this.objectStoreLocator.apply(config)), this.expressionEvaluator);
        AuthorizationCodeGrantType grantType = config.getGrantType();
        OAuthCallbackConfig callbackConfig = config.getCallbackConfig();
        dancerBuilder.name(config.getOwnerConfigName()).encoding(this.artifactEncoding.getDefaultEncoding()).clientCredentials(config.getConsumerKey(), config.getConsumerSecret()).responseExpiresInExpr(grantType.getExpirationRegex()).responseRefreshTokenExpr(grantType.getRefreshTokenExpr()).responseAccessTokenExpr(grantType.getAccessTokenExpr()).resourceOwnerIdTransformer(ownerId -> ownerId + "-" + config.getOwnerConfigName()).withClientCredentialsIn(ExtensionsOAuthUtils.toCredentialsLocation(grantType.getCredentialsPlacement()));
        if (config.getTlsContext() == null && config.getProxyConfig() == null) {
            dancerBuilder.tokenUrl(config.getAccessTokenUrl());
        } else if (config.getTlsContext() != null && config.getProxyConfig() != null) {
            dancerBuilder.tokenUrl(config.getAccessTokenUrl(), config.getTlsContext(), config.getProxyConfig());
        } else if (config.getTlsContext() != null) {
            dancerBuilder.tokenUrl(config.getAccessTokenUrl(), config.getTlsContext());
        } else {
            dancerBuilder.tokenUrl(config.getAccessTokenUrl(), config.getProxyConfig());
        }
        String scopes = config.getScope().orElseGet(() -> grantType.getDefaultScope().orElse(null));
        if (scopes != null) {
            dancerBuilder.scopes(scopes);
        }
        try {
            httpServer = ((HttpService)this.httpService.get()).getServerFactory().lookup(callbackConfig.getListenerConfig());
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Connector '%s' defines '%s' as the http:listener-config to use for provisioning callbacks, but no such definition exists in the application configuration", config.getOwnerConfigName(), callbackConfig.getListenerConfig())), (Throwable)e);
        }
        dancerBuilder.localCallback(httpServer, callbackConfig.getCallbackPath()).externalCallbackUrl(this.getExternalCallback(httpServer, callbackConfig)).authorizationUrl(config.getAuthorizationUrl()).localAuthorizationUrlPath(callbackConfig.getLocalAuthorizePath()).localAuthorizationUrlResourceOwnerId("#[attributes.queryParams.resourceOwnerId]").state("#[attributes.queryParams.state]").customParameters(config.getCustomQueryParameters()).customHeaders(config.getCustomHeaders()).customBodyParameters(config.getCustomBodyParameters()).customParametersExtractorsExprs(this.getParameterExtractors(config));
        dancerBuilder.includeRedirectUriInRefreshTokenRequest(grantType.includeRedirectUriInRefreshTokenRequest());
        Pair<Optional<Flow>, Optional<Flow>> listenerFlows = this.getListenerFlows(config);
        ((Optional)listenerFlows.getFirst()).ifPresent(arg_0 -> this.lambda$createDancer$4((OAuthAuthorizationCodeDancerBuilder)dancerBuilder, config, arg_0));
        ((Optional)listenerFlows.getSecond()).ifPresent(arg_0 -> this.lambda$createDancer$5((OAuthAuthorizationCodeDancerBuilder)dancerBuilder, config, arg_0));
        listeners.forEach(arg_0 -> ((OAuthAuthorizationCodeDancerBuilder)dancerBuilder).addListener(arg_0));
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)dancerBuilder.build();
        if (this.started) {
            this.start(dancer);
        }
        return dancer;
    }

    protected String getExternalCallback(HttpServer httpServer, OAuthCallbackConfig callbackConfig) {
        return callbackConfig.getExternalCallbackUrl().orElseGet(() -> {
            try {
                return new URL(httpServer.getProtocol().getScheme(), httpServer.getServerAddress().getIp(), httpServer.getServerAddress().getPort(), callbackConfig.getCallbackPath()).toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not derive a external callback url from <http:listener-config> '%s'", callbackConfig.getListenerConfig())), (Throwable)e);
            }
        });
    }

    protected Pair<Optional<Flow>, Optional<Flow>> getListenerFlows(AuthorizationCodeConfig config) {
        try {
            return new Pair(this.lookupFlow(config.getBefore()), this.lookupFlow(config.getAfter()));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not obtain 'before' and 'after' OAuth flows defined by config " + config.getOwnerConfigName()), (Object[])new Object[]{e}));
        }
    }

    protected Optional<Flow> lookupFlow(Optional<String> flowName) {
        return flowName.map(this::lookupFlow);
    }

    protected Flow lookupFlow(String flowName) {
        return (Flow)this.registry.lookupByName(flowName).orElseThrow(() -> new IllegalArgumentException("Flow " + flowName + " doesn't exist"));
    }

    protected Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeCallback(AuthorizationCodeConfig config, Flow flow) {
        return danceRequest -> {
            ImmutableAuthCodeRequest request = new ImmutableAuthCodeRequest(danceRequest.getResourceOwnerId(), danceRequest.getScopes(), danceRequest.getState().orElse(null), config.getCallbackConfig().getExternalCallbackUrl());
            CoreEvent event = this.runFlow(flow, this.createEvent(request, config, flow), config, "before");
            return paramKey -> DANCE_CALLBACK_EVENT_KEY.equals(paramKey) ? Optional.of(event) : Optional.empty();
        };
    }

    protected BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterCallback(AuthorizationCodeConfig config, Flow flow) {
        return (callbackContext, oauthContext) -> {
            AuthorizationCodeState state = ExtensionsOAuthUtils.toAuthorizationCodeState(config, oauthContext);
            CoreEvent event = (CoreEvent)callbackContext.getParameter(DANCE_CALLBACK_EVENT_KEY).orElseGet(() -> this.createEvent(state, config, flow));
            event = CoreEvent.builder((CoreEvent)event).message(Message.builder().value((Object)state).build()).build();
            this.runFlow(flow, event, config, "after");
        };
    }

    protected CoreEvent createEvent(Object payload, OAuthConfig config, Flow flow) {
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)DefaultComponentLocation.from((String)config.getOwnerConfigName()))).message(Message.builder().value(payload).build()).build();
    }

    protected CoreEvent runFlow(Flow flow, CoreEvent event, OAuthConfig config, String callbackType) {
        Publisher childPublisher = MessageProcessors.processWithChildContext((CoreEvent)event, (ReactiveProcessor)flow, (BaseEventContext)DefaultEventContext.child((BaseEventContext)((BaseEventContext)event.getContext()), Optional.of(flow.getLocation())));
        return (CoreEvent)Mono.from((Publisher)childPublisher).onErrorMap(MuleException.class, e -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Error found while execution flow '%s' which is configured in the '%s' parameter of the '%s' config", flow.getName(), callbackType, config.getOwnerConfigName()), (Object[])new Object[]{e}))).block();
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.httpService = new LazyLookup<HttpService>(HttpService.class, this.muleContext);
    }

    protected Map<String, AuthorizationCodeOAuthDancer> getDancers() {
        return this.dancers;
    }

    protected LazyValue<OAuthService> getOAuthService() {
        return this.oauthService;
    }

    private /* synthetic */ void lambda$createDancer$5(OAuthAuthorizationCodeDancerBuilder dancerBuilder, AuthorizationCodeConfig config, Flow flow) {
        dancerBuilder.afterDanceCallback(this.afterCallback(config, flow));
    }

    private /* synthetic */ void lambda$createDancer$4(OAuthAuthorizationCodeDancerBuilder dancerBuilder, AuthorizationCodeConfig config, Flow flow) {
        dancerBuilder.beforeDanceCallback(this.beforeCallback(config, flow));
    }
}

