/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.source;

import org.mule.runtime.api.functional.Either;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.runtime.source.SdkSourceFactory;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceFactoryContext;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConfigurer;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class JavaSdkSourceFactory
implements SdkSourceFactory {
    private final Class<?> sourceType;
    private final boolean isLegacySourceType;

    public JavaSdkSourceFactory(Class<?> sourceType) {
        IntrospectionUtils.checkInstantiable(sourceType, new ReflectionCache());
        if (Source.class.isAssignableFrom(sourceType)) {
            this.isLegacySourceType = true;
        } else if (org.mule.sdk.api.runtime.source.Source.class.isAssignableFrom(sourceType)) {
            this.isLegacySourceType = false;
        } else {
            throw new IllegalSourceModelDefinitionException(String.format("Source type %s must extend either %s or %s classes", sourceType.getName(), org.mule.sdk.api.runtime.source.Source.class.getName(), Source.class.getName()));
        }
        this.sourceType = sourceType;
    }

    public Either<org.mule.sdk.api.runtime.source.Source, Source> createMessageSource() {
        try {
            Object source = this.sourceType.getConstructor(new Class[0]).newInstance(new Object[0]);
            return this.isLegacySourceType ? Either.right((Object)((Source)source)) : Either.left((Object)((org.mule.sdk.api.runtime.source.Source)source));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception found trying to instantiate source type " + this.sourceType.getName(), e);
        }
    }

    public Source<?, ?> createMessageSource(SourceFactoryContext context) {
        try {
            Object source = this.sourceType.getConstructor(new Class[0]).newInstance(new Object[0]);
            SourceConfigurer sourceConfigurer = new SourceConfigurer(context);
            return sourceConfigurer.configure(source);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception found trying to instantiate and configure source type " + this.sourceType.getName(), e);
        }
    }
}

