/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaAttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaOutputResolverModelParser;
import org.mule.runtime.module.extension.internal.metadata.chain.AllOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.OneOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.PassThroughChainOutputTypeResolver;
import org.mule.sdk.api.annotation.metadata.AllOfRoutesOutputChainResolver;
import org.mule.sdk.api.annotation.metadata.OneOfRoutesOutputChainResolver;
import org.mule.sdk.api.annotation.metadata.PassThroughOutputChainResolver;

public class JavaShortHandOutputResolver {
    private static final Iterable<JavaShortHandOutputResolver> SHORT_HAND_OUTPUT_RESOLVERS = Arrays.asList(new JavaShortHandOutputResolver(PassThroughOutputChainResolver.class, PassThroughChainOutputTypeResolver.INSTANCE, PassThroughChainOutputTypeResolver.INSTANCE), new JavaShortHandOutputResolver(OneOfRoutesOutputChainResolver.class, OneOfRoutesOutputTypeResolver.INSTANCE, OneOfRoutesOutputTypeResolver.INSTANCE), new JavaShortHandOutputResolver(AllOfRoutesOutputChainResolver.class, AllOfRoutesOutputTypeResolver.INSTANCE));
    private final Class<? extends Annotation> annotation;
    private final Optional<OutputResolverModelParser> outputResolverModelParser;
    private final Optional<AttributesResolverModelParser> attributesResolverModelParser;

    public static Optional<JavaShortHandOutputResolver> findShortHandOutputResolver(WithAnnotations annotatedElement) {
        for (JavaShortHandOutputResolver shortHandResolver : SHORT_HAND_OUTPUT_RESOLVERS) {
            if (!annotatedElement.getValueFromAnnotation(shortHandResolver.getAnnotation()).isPresent()) continue;
            return Optional.of(shortHandResolver);
        }
        return Optional.empty();
    }

    private JavaShortHandOutputResolver(Class<? extends Annotation> annotation, OutputTypeResolver<?> outputResolverModelParser, AttributesTypeResolver<?> attributesResolverModelParser) {
        this.annotation = annotation;
        this.outputResolverModelParser = Optional.ofNullable(outputResolverModelParser).map(JavaOutputResolverModelParser::new);
        this.attributesResolverModelParser = Optional.ofNullable(attributesResolverModelParser).map(JavaAttributesResolverModelParser::new);
    }

    private JavaShortHandOutputResolver(Class<? extends Annotation> annotation, OutputTypeResolver<?> outputResolverModelParser) {
        this(annotation, outputResolverModelParser, null);
    }

    private Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
        return this.outputResolverModelParser;
    }

    public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
        return this.attributesResolverModelParser;
    }
}

