/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.parser.FieldValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.property.DefaultImplementingTypeModelProperty;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.privileged.semantic.SemanticTermsHelper;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExclusiveOptionalModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.HasExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaFieldValueProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaValueProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.SdkParameterPlacementUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.SdkStereotypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaInputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataKeyIdModelParserUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.ConfigReferences;
import org.mule.sdk.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;
import org.mule.sdk.api.annotation.param.ConfigOverride;
import org.mule.sdk.api.annotation.param.reference.ConfigReference;
import org.mule.sdk.api.annotation.param.reference.ObjectStoreReference;
import org.mule.sdk.api.annotation.param.stereotype.ComponentId;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

public class JavaParameterModelParser
implements ParameterModelParser,
HasExtensionParameter {
    private final Optional<ExtensionParameter> owningParameterGroupElement;
    private final ExtensionParameter parameter;
    private final MetadataType type;
    private final Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionals;
    private final List<ModelProperty> additionalModelProperties = new LinkedList<ModelProperty>();
    private final ParameterDeclarationContext context;
    private Optional<ParameterDslConfiguration> dslConfiguration;
    private ExpressionSupport expressionSupport;

    public JavaParameterModelParser(ExtensionParameter parameter, Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionals, Optional<ExtensionParameter> owningParameterGroupElement, ParameterDeclarationContext context) {
        this.owningParameterGroupElement = owningParameterGroupElement;
        this.parameter = parameter;
        this.context = context;
        this.exclusiveOptionals = exclusiveOptionals;
        this.type = CustomStaticTypeUtils.getParameterType(parameter);
        this.parserStructure();
        this.collectAdditionalModelProperties();
    }

    private void parserStructure() {
        this.parseExpressionSupport();
        this.parseExclusiveOptionals();
    }

    public String getName() {
        return this.parameter.getAlias();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.parameter.isRequired();
    }

    public Object getDefaultValue() {
        return this.parameter.defaultValue().orElse(null);
    }

    public ParameterRole getRole() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), Content.class, org.mule.sdk.api.annotation.param.Content.class, legacyContentAnnotationValueFetcher -> legacyContentAnnotationValueFetcher.getBooleanValue(Content::primary) != false ? ParameterRole.PRIMARY_CONTENT : ParameterRole.CONTENT, sdkContentAnnotationValueFetcher -> sdkContentAnnotationValueFetcher.getBooleanValue(org.mule.sdk.api.annotation.param.Content::primary) != false ? ParameterRole.PRIMARY_CONTENT : ParameterRole.CONTENT).orElse(ParameterRole.BEHAVIOUR);
    }

    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    public Optional<LayoutModel> getLayoutModel() {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(this.parameter, LayoutModel.builder(), this.parameter.getName());
    }

    public Optional<ParameterDslConfiguration> getDslConfiguration() {
        if (this.dslConfiguration == null) {
            this.dslConfiguration = MuleExtensionAnnotationParser.mapReduceAnnotation(this.parameter, org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class, ParameterDsl.class, legacyAnnotationValueFetcher -> ParameterDslConfiguration.builder().allowsInlineDefinition(legacyAnnotationValueFetcher.getBooleanValue(org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl::allowInlineDefinition).booleanValue()).allowsReferences(legacyAnnotationValueFetcher.getBooleanValue(org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl::allowReferences).booleanValue()).build(), sdkAnnotationValueFetcher -> ParameterDslConfiguration.builder().allowsInlineDefinition(sdkAnnotationValueFetcher.getBooleanValue(ParameterDsl::allowInlineDefinition).booleanValue()).allowsReferences(sdkAnnotationValueFetcher.getBooleanValue(ParameterDsl::allowReferences).booleanValue()).build(), () -> new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", this.parameter.getName(), org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class.getName(), ParameterDsl.class.getName())));
        }
        return this.dslConfiguration;
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.parameter);
    }

    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.parameter, "parameter", this.parameter.getName());
    }

    public boolean isConfigOverride() {
        return this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.ConfigOverride.class) || this.parameter.isAnnotatedWith(ConfigOverride.class);
    }

    public Optional<ValueProviderModelParser> getValueProviderModelParser() {
        Optional<ValueProviderModelParser> vpParserFromGroup = this.owningParameterGroupElement.flatMap(owningGroupElem -> JavaValueProviderModelParser.parseFromOfValues(owningGroupElem, this.parameter, "parameter group", this.context.getLoadingContext().getTypeLoader()));
        if (vpParserFromGroup.isPresent() && ((ValueProviderModelParser)vpParserFromGroup.get()).getPartOrder().isPresent()) {
            return vpParserFromGroup;
        }
        return JavaValueProviderModelParser.parseFromOfValues(this.parameter, this.parameter, "parameter", this.context.getLoadingContext().getTypeLoader()).map(ValueProviderModelParser.class::cast);
    }

    public List<FieldValueProviderModelParser> getFieldValueProvidersModelParser() {
        return JavaFieldValueProviderModelParser.getParserFromFieldValues(this.parameter, this.context.getLoadingContext().getTypeLoader());
    }

    public boolean isComponentId() {
        return this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId.class) || this.parameter.isAnnotatedWith(ComponentId.class);
    }

    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        if (this.parameter.isAnnotatedWith(FlowReference.class) || this.parameter.isAnnotatedWith(org.mule.sdk.api.annotation.param.reference.FlowReference.class)) {
            return Collections.singletonList(MuleStereotypes.FLOW);
        }
        if (this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference.class) || this.parameter.isAnnotatedWith(ObjectStoreReference.class)) {
            return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
        }
        List stereotypes = MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(this.parameter, org.mule.runtime.extension.api.annotation.param.reference.ConfigReference.class, ConfigReference.class, container -> ((org.mule.runtime.extension.api.annotation.ConfigReferences)container).value(), container -> ((ConfigReferences)container).value(), value -> factory.createStereotype(value.getStringValue(org.mule.runtime.extension.api.annotation.param.reference.ConfigReference::name), value.getStringValue(org.mule.runtime.extension.api.annotation.param.reference.ConfigReference::namespace), org.mule.sdk.api.stereotype.MuleStereotypes.CONFIG), value -> factory.createStereotype(value.getStringValue(ConfigReference::name), value.getStringValue(ConfigReference::namespace), org.mule.sdk.api.stereotype.MuleStereotypes.CONFIG)).collect(Collectors.toList());
        if (stereotypes.isEmpty()) {
            stereotypes = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), AllowedStereotypes.class, org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes.class, value -> value.getClassArrayValue(AllowedStereotypes::value).stream().filter(type -> type.getDeclaringClass().isPresent()).map(type -> SdkStereotypeDefinitionAdapter.from(type.getDeclaringClass().get())), value -> value.getClassArrayValue(org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes::value).stream().filter(type -> type.getDeclaringClass().isPresent()).map(type -> SdkStereotypeDefinitionAdapter.from(type.getDeclaringClass().get()))).map(stream -> stream.map(def -> factory.createStereotype(def)).collect(Collectors.toList())).orElse(new LinkedList());
        }
        stereotypes.addAll(this.type.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()));
        return stereotypes;
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return this.additionalModelProperties;
    }

    public boolean isExcludedFromConnectivitySchema() {
        return this.parameter.isAnnotatedWith(ExcludeFromConnectivitySchema.class);
    }

    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getParameterTermsFromAnnotations(this.parameter::isAnnotatedWith));
        final LinkedHashSet<String> typeTerms = new LinkedHashSet<String>(ExtensionMetadataTypeUtils.getSemanticTerms((MetadataType)this.getType()));
        SemanticTermsParserUtils.addTermIfPresent(typeTerms, "connectivity.ProxyConfiguration", "connectivity.proxyConfiguration", terms);
        SemanticTermsParserUtils.addTermIfPresent(typeTerms, "connectivity.NtlmProxyConfiguration", "connectivity.ntlmProxyConfiguration", terms);
        if (typeTerms.contains("connectivity.secret")) {
            this.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    typeTerms.remove("connectivity.secret");
                    typeTerms.add("connectivity.scalarSecret");
                }
            });
        }
        SemanticTermsParserUtils.addCustomTerms(this.parameter, terms);
        return terms;
    }

    public Optional<OAuthParameterModelProperty> getOAuthParameterModelProperty() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter.class, OAuthParameter.class, oAuthParameterAnnotationValueFetcher -> new OAuthParameterModelProperty(oAuthParameterAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter::requestAlias), oAuthParameterAnnotationValueFetcher.getEnumValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter::placement)), oAuthParameterAnnotationValueFetcher -> new OAuthParameterModelProperty(oAuthParameterAnnotationValueFetcher.getStringValue(OAuthParameter::requestAlias), SdkParameterPlacementUtils.from(oAuthParameterAnnotationValueFetcher.getEnumValue(OAuthParameter::placement))));
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.empty();
    }

    public Optional<InputResolverModelParser> getInputResolverModelParser() {
        return JavaInputResolverModelParserUtils.getResolverParser(this.parameter);
    }

    public Optional<Pair<Integer, Boolean>> getMetadataKeyPart() {
        Optional<MetadataKeyModelParser> metadataKeyModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(this.parameter, null, null);
        if (metadataKeyModelParser.isPresent()) {
            return Optional.of(new Pair((Object)1, (Object)(metadataKeyModelParser.get().hasKeyIdResolver() || this.context.isKeyResolverAvailable() ? 1 : 0)));
        }
        return JavaMetadataKeyIdModelParserUtils.getMetadataKeyPart(this.parameter);
    }

    private void collectAdditionalModelProperties() {
        this.additionalModelProperties.add(new ExtensionParameterDescriptorModelProperty(this.parameter));
        this.collectImplementingTypeProperties();
        this.collectNullSafeProperties();
        this.collectInfrastructureModelProperties();
        this.collectStackableTypesModelProperty();
    }

    private void collectStackableTypesModelProperty() {
        this.additionalModelProperties.addAll(this.context.resolveStackableTypes(this.parameter));
    }

    private void collectInfrastructureModelProperties() {
        if (this.parameter instanceof FieldElement) {
            InfrastructureTypeResolver.getInfrastructureType(this.parameter.getType()).ifPresent(infrastructureType -> {
                if (!StringUtils.isBlank((CharSequence)infrastructureType.getName())) {
                    this.additionalModelProperties.add((ModelProperty)new InfrastructureParameterModelProperty(infrastructureType.getSequence()));
                    this.expressionSupport = ExpressionSupport.NOT_SUPPORTED;
                    infrastructureType.getQNameModelProperty().ifPresent(this.additionalModelProperties::add);
                    infrastructureType.getDslConfiguration().ifPresent(dsl -> {
                        this.dslConfiguration = Optional.of(dsl);
                    });
                }
            });
        }
    }

    private void collectImplementingTypeProperties() {
        this.parameter.getDeclaringElement().ifPresent(element -> {
            if (element instanceof Field) {
                this.additionalModelProperties.add(new DeclaringMemberModelProperty((Field)element));
            } else {
                this.additionalModelProperties.add(new ImplementingParameterModelProperty((Parameter)element));
            }
        });
    }

    private void parseExpressionSupport() {
        this.expressionSupport = IntrospectionUtils.getExpressionSupport(this.parameter, "parameter", this.getName()).orElse(ExpressionSupport.SUPPORTED);
    }

    private void parseExclusiveOptionals() {
        this.exclusiveOptionals.ifPresent(exclusive -> {
            ImmutableExclusiveParametersModel exclusiveParametersModel = new ImmutableExclusiveParametersModel(exclusive.getExclusiveOptionals(), exclusive.isOneRequired());
            this.additionalModelProperties.add(new ExclusiveOptionalModelProperty((ExclusiveParametersModel)exclusiveParametersModel));
        });
    }

    private void collectNullSafeProperties() {
        final Optional<Type> nullSafeAnnotationType = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), NullSafe.class, org.mule.sdk.api.annotation.param.NullSafe.class, value -> value.getClassValue(NullSafe::defaultImplementingType), value -> value.getClassValue(org.mule.sdk.api.annotation.param.NullSafe::defaultImplementingType));
        if (nullSafeAnnotationType.isPresent()) {
            if (this.isConfigOverride()) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and also marked as a config override, which is redundant. The default value for this parameter will come from the configuration parameter", this.parameter.getName(), NullSafe.class.getSimpleName()));
            }
            if (this.parameter.isRequired() && !this.parameter.isAnnotatedWith(ParameterGroup.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is required but annotated with '@%s', which is redundant", this.parameter.getName(), NullSafe.class.getSimpleName()));
            }
            final boolean hasDefaultOverride = !nullSafeAnnotationType.get().isSameType(Object.class);
            final MetadataType nullSafeType = hasDefaultOverride ? nullSafeAnnotationType.get().asMetadataType() : this.type;
            final boolean isInstantiable = hasDefaultOverride ? nullSafeAnnotationType.get().isInstantiable() : this.parameter.getType().isInstantiable();
            this.type.accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (hasDefaultOverride && ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (hasDefaultOverride && JavaParameterModelParser.this.parameter.getType().isInstantiable()) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (!isInstantiable && !ExtensionMetadataTypeUtils.isMap((MetadataType)nullSafeType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (hasDefaultOverride && !JavaParameterModelParser.this.parameter.getType().isAssignableFrom((Type)nullSafeAnnotationType.get())) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName(), JavaTypeUtils.getType((MetadataType)nullSafeType).getName()));
                    }
                }
            });
            this.additionalModelProperties.add(new NullSafeModelProperty(nullSafeType));
            if (hasDefaultOverride) {
                this.additionalModelProperties.add((ModelProperty)new DefaultImplementingTypeModelProperty(nullSafeType));
            }
        }
    }

    @Override
    public ExtensionParameter getExtensionParameter() {
        return this.parameter;
    }
}

