/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader;

import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.loader.AbstractParserBasedExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;

public abstract class AbstractExtensionModelLoader
extends AbstractParserBasedExtensionModelLoader {
    private static boolean IGNORE_DISABLED = System.getProperty("mule.disableSdkComponentIgnore") != null;
    private static final boolean ENABLE_POLLING_SOURCE_LIMIT = System.getProperty("mule.enablePollingSourceLimit") != null;

    public static void setIgnoreDisabled(boolean value) {
        IGNORE_DISABLED = value;
    }

    public static boolean getIgnoreDisabled() {
        return IGNORE_DISABLED;
    }

    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        Optional<Object> addAnnotationstoConfigClass;
        Optional<Object> disableComponentIgnore = this.checkBoolean(context, "EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE");
        if (IGNORE_DISABLED && !disableComponentIgnore.isPresent()) {
            context.addParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)true);
        }
        if (ENABLE_POLLING_SOURCE_LIMIT) {
            context.addParameter("EXTENSION_LOADER_ENABLE_POLLING_SOURCE_LIMIT", (Object)true);
        }
        if ((addAnnotationstoConfigClass = this.checkBoolean(context, "EXTENSION_LOADER_ADD_ANNOTATIONS_TO_CONFIG_CLASS")).isPresent()) {
            context.addParameter("EXTENSION_LOADER_ADD_ANNOTATIONS_TO_CONFIG_CLASS", addAnnotationstoConfigClass.get());
        }
    }

    private Optional<Object> checkBoolean(ExtensionLoadingContext context, String paramMame) {
        Optional addAnnotationstoConfigClass = context.getParameter(paramMame);
        addAnnotationstoConfigClass.ifPresent(value -> Preconditions.checkState((boolean)(value instanceof Boolean), (String)String.format("Property value for %s expected to be boolean", paramMame)));
        return addAnnotationstoConfigClass;
    }

    protected ModelLoaderDelegate getModelLoaderDelegate(ExtensionLoadingContext context, String version) {
        return new DefaultExtensionModelLoaderDelegate(version);
    }
}

