/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class ParameterGroupArgumentResolver<T>
implements ArgumentResolver<T> {
    private final ParameterGroupDescriptor group;
    private final ReflectionCache reflectionCache;

    public ParameterGroupArgumentResolver(ParameterGroupDescriptor group, ReflectionCache reflectionCache) {
        Preconditions.checkState((boolean)group.getType().isInstantiable(), (String)"Class %s cannot be instantiated.");
        this.group = group;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public LazyValue<T> resolve(ExecutionContext executionContext) {
        return new LazyValue(() -> {
            try {
                return new ParameterGroupObjectBuilder(this.group, this.reflectionCache).build((EventedExecutionContext)executionContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create parameter group"), (Throwable)e);
            }
        });
    }
}

