/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class StaticConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements InjectedDependenciesProvider {
    private final ConfigurationInstance configuration;

    public StaticConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, muleContext);
        this.configuration = configuration;
        this.registerConfiguration(configuration);
    }

    public ConfigurationInstance get(Event muleEvent) {
        return this.configuration;
    }

    public Collection<Either<Class<?>, String>> getInjectedDependencies() {
        return IntrospectionUtils.getAnnotatedFields(this.configuration.getValue().getClass(), Inject.class).stream().map(field -> {
            Named name = field.getAnnotation(Named.class);
            return name != null ? Either.right((Object)name.value()) : Either.left(field.getType());
        }).collect(Collectors.toList());
    }

    public boolean isDynamic() {
        return false;
    }
}

