/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ParameterPluralNameModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                ParameterPluralNameModelValidator.this.validateParameterIsPlural(model, owner, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateParameterIsPlural(final ParameterModel parameterModel, final ParameterizedModel owner, final ProblemsReporter problemsReporter) {
        parameterModel.getType().accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                if (parameterModel.getName().equals(NameUtils.singularize((String)parameterModel.getName()))) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is a collection and its name should be plural", parameterModel.getName(), NameUtils.getComponentModelTypeName((ParameterizedModel)owner), owner.getName())));
                }
            }
        });
    }
}

