/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.InterceptableOperationExecutorWrapper;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReactiveOperationExecutionWrapper;

public final class OperationExecutorFactoryWrapper
implements OperationExecutorFactory,
OperationArgumentResolverFactory {
    private final OperationExecutorFactory delegate;
    private final List<Interceptor> interceptors;

    public OperationExecutorFactoryWrapper(OperationExecutorFactory delegate, List<Interceptor> interceptors) {
        this.delegate = delegate;
        this.interceptors = interceptors;
    }

    public OperationExecutor createExecutor(OperationModel operationModel) {
        OperationExecutor executor = this.delegate.createExecutor(operationModel);
        executor = new ReactiveOperationExecutionWrapper(executor);
        executor = new InterceptableOperationExecutorWrapper(executor, this.interceptors);
        return executor;
    }

    @Override
    public Function<ExecutionContext<OperationModel>, Map<String, Object>> createArgumentResolver(OperationModel operationModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)this.delegate).createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

