/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExecutableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.TypedException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ModuleExceptionHandler {
    private final ComponentModel componentModel;
    private ExtensionModel extensionModel;
    private final ErrorTypeRepository typeRepository;
    private final Set<ErrorModel> allowedErrorTypes;
    private final String extensionNamespace;

    public ModuleExceptionHandler(ExecutableComponentModel componentModel, ExtensionModel extensionModel, ErrorTypeRepository typeRepository) {
        this.componentModel = componentModel;
        this.extensionModel = extensionModel;
        this.typeRepository = typeRepository;
        this.allowedErrorTypes = componentModel.getErrorModels();
        this.extensionNamespace = MuleExtensionUtils.getExtensionsErrorNamespace(extensionModel);
    }

    public Throwable processException(Throwable throwable) {
        if (throwable instanceof ModuleException) {
            ErrorTypeDefinition errorDefinition = ((ModuleException)throwable).getType();
            return this.handleTypedException(throwable, errorDefinition);
        }
        return throwable;
    }

    private Throwable handleTypedException(Throwable exception, ErrorTypeDefinition errorDefinition) {
        if (!this.isAllowedError(errorDefinition)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but only %s errors are allowed.", (Object[])new Object[]{this.componentModel.getName(), this.extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition, this.allowedErrorTypes}), exception.getCause());
        }
        ErrorType errorType = (ErrorType)this.typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(this.extensionNamespace).name(errorDefinition.getType()).build()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but it was not registered in the Error Repository", (Object[])new Object[]{this.componentModel.getName(), this.extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition}), this.getExceptionCause(exception)));
        return new TypedException(this.getExceptionCause(exception), errorType);
    }

    private boolean isAllowedError(ErrorTypeDefinition errorTypeDefinition) {
        return this.allowedErrorTypes.stream().anyMatch(errorModel -> errorModel.getType().equals(errorTypeDefinition.getType()) && errorModel.getNamespace().equals(this.extensionNamespace));
    }

    private Throwable getExceptionCause(Throwable throwable) {
        return throwable.getClass().equals(ModuleException.class) ? throwable.getCause() : throwable;
    }
}

