/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionBindingDelegate;

public class ExtensionConnectionSupplier {
    @Inject
    private ConnectionManager connectionManager;

    public ConnectionHandler<?> getConnection(ExecutionContextAdapter<? extends ComponentModel> executionContext) throws ConnectionException, TransactionException {
        return executionContext.getTransactionConfig().isPresent() ? this.getTransactedConnectionHandler(executionContext, executionContext.getTransactionConfig().get()) : this.getTransactionlessConnectionHandler(executionContext);
    }

    private <T extends TransactionalConnection> ConnectionHandler<T> getTransactedConnectionHandler(ExecutionContextAdapter<? extends ComponentModel> executionContext, TransactionConfig transactionConfig) throws ConnectionException, TransactionException {
        if (!transactionConfig.isTransacted()) {
            return this.getTransactionlessConnectionHandler(executionContext);
        }
        ExtensionModel extensionModel = executionContext.getExtensionModel();
        ComponentModel componentModel = executionContext.getComponentModel();
        ConfigurationInstance configuration = (ConfigurationInstance)executionContext.getConfiguration().orElseThrow(() -> new IllegalStateException(String.format("%s '%s' of extension '%s' cannot participate in a transaction because it doesn't have a config", NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel), componentModel.getName(), extensionModel.getName())));
        ExtensionTransactionKey txKey = new ExtensionTransactionKey(configuration);
        TransactionBindingDelegate transactionBindingDelegate = new TransactionBindingDelegate(extensionModel, componentModel);
        return transactionBindingDelegate.getBoundResource(transactionConfig, txKey, () -> this.getTransactionlessConnectionHandler(executionContext));
    }

    private <T> ConnectionHandler<T> getTransactionlessConnectionHandler(ExecutionContext executionContext) throws ConnectionException {
        Optional configuration = executionContext.getConfiguration();
        Optional<ConnectionProvider> connectionProvider = configuration.map(ConfigurationInstance::getConnectionProvider).filter(Optional::isPresent).map(Optional::get);
        if (!connectionProvider.isPresent()) {
            String configRef = configuration.map(config -> String.format("with config '%s' which is not associated to a connection provider", config.getName())).orElse("without a config");
            throw new IllegalStateException(String.format("%s '%s' of extension '%s' requires a connection but was executed %s", NameUtils.getComponentModelTypeName((ParameterizedModel)executionContext.getComponentModel()), executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName(), configRef));
        }
        return this.connectionManager.getConnection(((ConfigurationInstance)configuration.get()).getValue());
    }
}

