/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.StaticConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;

public final class ConfigurationProviderToolingAdapter
extends StaticConfigurationProvider
implements MetadataKeyProvider,
ConfigurationParameterValueProvider {
    private final MuleMetadataService metadataService;
    protected final ConnectionManager connectionManager;
    private final ConfigurationInstance configuration;

    ConfigurationProviderToolingAdapter(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, configuration, muleContext);
        this.configuration = configuration;
        this.connectionManager = (ConnectionManager)muleContext.getRegistry().get("_muleConnectionManager");
        try {
            this.metadataService = (MuleMetadataService)muleContext.getRegistry().lookupObject(MuleMetadataService.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        MetadataKeysContainerBuilder keysBuilder = MetadataKeysContainerBuilder.getInstance();
        try {
            MetadataContext metadataContext = this.getMetadataContext();
            this.addComponentKeys(this.getConfigurationModel().getOperationModels(), metadataContext, keysBuilder);
            this.addComponentKeys(this.getConfigurationModel().getSourceModels(), metadataContext, keysBuilder);
            metadataContext.dispose();
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()});
        }
        return MetadataResult.success((Object)keysBuilder.build());
    }

    private void addComponentKeys(List<? extends ComponentModel> components, MetadataContext metadataContext, MetadataKeysContainerBuilder keysBuilder) throws MetadataResolvingException, ConnectionException {
        for (ComponentModel componentModel : components) {
            TypeKeysResolver keysResolver = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)componentModel).getKeyResolver();
            String categoryName = keysResolver.getCategoryName();
            if ("NullCategory".equals(categoryName) || keysBuilder.containsCategory(categoryName)) continue;
            keysBuilder.add(categoryName, keysResolver.getKeys(metadataContext));
        }
    }

    private MetadataContext getMetadataContext() throws MetadataResolvingException, ConnectionException {
        InternalEvent fakeEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new DefaultMetadataContext(Optional.of(this.get(fakeEvent)), this.connectionManager, this.metadataService.getMetadataCache(this.getName()), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionUtils.getClassLoader(this.getExtensionModel())));
    }

    public Set<Value> getConfigValues(String parameterName) throws ValueResolvingException {
        return this.valuesWithClassLoader(() -> {
            ConfigurationModel configurationModel = this.getConfigurationModel();
            return new ValueProviderMediator<ConfigurationModel>(configurationModel, this.muleContext).getValues(parameterName, this.getParameterValueResolver(this.configuration.getValue(), (ParameterizedModel)configurationModel));
        });
    }

    public Set<Value> getConnectionValues(String parameterName) throws ValueResolvingException {
        return this.valuesWithClassLoader(() -> {
            ConnectionProvider connectionProvider = (ConnectionProvider)this.configuration.getConnectionProvider().orElseThrow(() -> new ValueResolvingException("Unable to obtain the Connection Provider Instance", "UNKNOWN"));
            ConnectionProvider unwrap = this.unwrap(connectionProvider);
            ConnectionProviderModel connectionProviderModel = IntrospectionUtils.getConnectionProviderModel(unwrap.getClass(), MuleExtensionUtils.getAllConnectionProviders(this.getExtensionModel(), this.getConfigurationModel())).orElseThrow(() -> new ValueResolvingException("Internal error. Unable to obtain the Connection Provider Model", "UNKNOWN"));
            ValueProviderMediator<ConnectionProviderModel> valueProviderMediator = new ValueProviderMediator<ConnectionProviderModel>(connectionProviderModel, this.muleContext);
            return valueProviderMediator.getValues(parameterName, this.getParameterValueResolver(unwrap, (ParameterizedModel)connectionProviderModel));
        });
    }

    private Set<Value> valuesWithClassLoader(Callable<Set<Value>> valueResolver) throws ValueResolvingException {
        Reference exceptionReference = new Reference();
        Set values = (Set)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.getExtensionModel()), valueResolver, ValueResolvingException.class, e -> {
            exceptionReference.set((Object)((ValueResolvingException)e));
            return null;
        });
        if (exceptionReference.get() != null) {
            throw (ValueResolvingException)exceptionReference.get();
        }
        return values;
    }

    private ParameterValueResolver getParameterValueResolver(Object object, ParameterizedModel configurationModel) {
        return new ObjectBasedParameterValueResolver(object, configurationModel);
    }

    private <C> ConnectionProvider<C> unwrap(ConnectionProvider<C> connectionProvider) {
        return connectionProvider instanceof ConnectionProviderWrapper ? this.unwrap(((ConnectionProviderWrapper)connectionProvider).getDelegate()) : connectionProvider;
    }
}

