/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.el.DefaultBindingContextBuilder;
import org.mule.runtime.core.el.DefaultExpressionModuleBuilder;
import org.mule.runtime.core.internal.transformer.simple.StringToEnum;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutor;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionParameterDefaultValueResolverFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ExtensionActivator
implements Startable,
Stoppable {
    private final ExtensionErrorsRegistrant extensionErrorsRegistrant;
    private final MuleRegistry registry;
    private final MuleContext muleContext;
    private final Set<Class<? extends Enum>> enumTypes = new HashSet<Class<? extends Enum>>();
    private final List<Object> lifecycleAwareElements = new LinkedList<Object>();

    ExtensionActivator(ExtensionErrorsRegistrant extensionErrorsRegistrant, MuleContext muleContext) {
        this.extensionErrorsRegistrant = extensionErrorsRegistrant;
        this.registry = muleContext.getRegistry();
        this.muleContext = muleContext;
    }

    void activateExtension(ExtensionModel extensionModel) {
        this.extensionErrorsRegistrant.registerErrors(extensionModel);
        this.registerEnumTransformers(extensionModel);
        this.registerExpressionFunctions(extensionModel);
    }

    private void registerEnumTransformers(ExtensionModel extensionModel) {
        IntrospectionUtils.getParameterClasses(extensionModel, MuleExtensionUtils.getClassLoader(extensionModel)).stream().filter(type -> Enum.class.isAssignableFrom((Class<?>)type)).forEach(type -> {
            Class enumClass = type;
            if (this.enumTypes.add(enumClass)) {
                try {
                    this.registry.registerTransformer((Transformer)new StringToEnum(enumClass));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not register transformer for enum " + enumClass.getName())), (Throwable)e);
                }
            }
        });
    }

    private void registerExpressionFunctions(ExtensionModel extensionModel) {
        if (extensionModel.getFunctionModels().isEmpty()) {
            return;
        }
        DefaultExpressionModuleBuilder moduleBuilder = new DefaultExpressionModuleBuilder(new ModuleNamespace(new String[]{StringUtils.capitalize((String)extensionModel.getXmlDslModel().getPrefix())}));
        this.registerExpressionFunctions(extensionModel.getFunctionModels().stream(), (ExpressionModule.Builder)moduleBuilder);
        try {
            BindingContext bindingContext = new DefaultBindingContextBuilder().addModule(moduleBuilder.build()).build();
            this.muleContext.getRegistry().registerObject(extensionModel.getName() + "GlobalBindingContextProvider", () -> bindingContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    private void registerExpressionFunctions(Stream<FunctionModel> functions, ExpressionModule.Builder module) {
        FunctionParameterDefaultValueResolverFactory valueResolverFactory = (defaultValue, type) -> context -> {
            String value;
            ExtendedExpressionManager em = this.muleContext.getExpressionManager();
            return em.isExpression(value = String.valueOf(defaultValue)) ? em.evaluate(value, type, context) : new TypedValue(defaultValue, type);
        };
        functions.forEach(function -> function.getModelProperty(FunctionExecutorModelProperty.class).ifPresent(mp -> {
            FunctionExecutor executor = mp.getExecutorFactory().createExecutor((FunctionModel)function, valueResolverFactory);
            this.lifecycleAwareElements.add(executor);
            module.addBinding(function.getName(), new TypedValue((Object)executor, DataType.fromFunction((ExpressionFunction)executor)));
        }));
    }

    public void start() throws MuleException {
        for (Object element : this.lifecycleAwareElements) {
            LifecycleUtils.initialiseIfNeeded((Object)element, (MuleContext)this.muleContext);
            LifecycleUtils.startIfNeeded((Object)element);
        }
    }

    public void stop() throws MuleException {
        for (Object element : this.lifecycleAwareElements) {
            LifecycleUtils.stopIfNeeded((Object)element);
        }
        this.lifecycleAwareElements.clear();
        this.enumTypes.clear();
    }

    public Set<Class<? extends Enum>> getEnumTypes() {
        return this.enumTypes;
    }
}

