/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.springframework.core.ResolvableType;

public class FieldWrapper
implements FieldElement {
    private final Field field;

    public FieldWrapper(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getAnnotation(annotationClass));
    }

    @Override
    public TypeWrapper getType() {
        return new TypeWrapper(this.field.getType());
    }

    @Override
    public Type getJavaType() {
        return ResolvableType.forField((Field)this.field).getType();
    }

    @Override
    public String getAlias() {
        return Optional.ofNullable(InfrastructureTypeMapping.getMap().get(this.field.getType())).map(InfrastructureTypeMapping.InfrastructureType::getName).orElse(FieldElement.super.getAlias());
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Class: '%s'", this.field.getDeclaringClass().getSimpleName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldWrapper) {
            return ((FieldWrapper)obj).getField().equals(this.field);
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

