/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.module.extension.internal.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ComponentWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConfigurationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ExtensionTypeWrapper<T>
extends ComponentWrapper
implements ExtensionElement,
ParameterizableTypeElement {
    public ExtensionTypeWrapper(Class<T> aClass) {
        super(aClass);
    }

    @Override
    public List<ConfigurationElement> getConfigurations() {
        Optional<Configurations> optionalConfigurations = this.getAnnotation(Configurations.class);
        if (optionalConfigurations.isPresent()) {
            Configurations configurations = optionalConfigurations.get();
            return Stream.of(configurations.value()).map(ConfigurationWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<MethodElement> getOperations() {
        return this.getAnnotation(Operations.class).map(classes -> Stream.of(classes.value()).flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new MethodWrapper((Method)clazz)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public List<MethodElement> getFunctions() {
        return this.getAnnotation(ExpressionFunctions.class).map(classes -> Stream.of(classes.value()).flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new MethodWrapper((Method)clazz)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

