/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ErrorArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.FlowListenerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.LiteralArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MediaTypeArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SecurityContextHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCallbackContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceResultArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StreamingHelperArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueArgumentResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class MethodArgumentResolverDelegate
implements ArgumentResolverDelegate {
    private static final ArgumentResolver<Object> CONFIGURATION_ARGUMENT_RESOLVER = new ConfigurationArgumentResolver();
    private static final ArgumentResolver<Object> CONNECTOR_ARGUMENT_RESOLVER = new ConnectionArgumentResolver();
    private static final ArgumentResolver<MediaType> MEDIA_TYPE_ARGUMENT_RESOLVER = new MediaTypeArgumentResolver();
    private static final ArgumentResolver<SourceCallbackContext> SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER = new SourceCallbackContextArgumentResolver();
    private static final ArgumentResolver<Error> ERROR_ARGUMENT_RESOLVER = new ErrorArgumentResolver();
    private static final ArgumentResolver<CompletionCallback> NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER = new CompletionCallbackArgumentResolver();
    private static final ArgumentResolver<SourceCompletionCallback> ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER = new SourceCompletionCallbackArgumentResolver();
    private static final ArgumentResolver<AuthenticationHandler> SECURITY_CONTEXT_HANDLER = new SecurityContextHandlerArgumentResolver();
    private static final ArgumentResolver<FlowListener> FLOW_LISTENER_ARGUMENT_RESOLVER = new FlowListenerArgumentResolver();
    private static final ArgumentResolver<StreamingHelper> STREAMING_HELPER_ARGUMENT_RESOLVER = new StreamingHelperArgumentResolver();
    private static final ArgumentResolver<SourceResult> SOURCE_RESULT_ARGUMENT_RESOLVER = new SourceResultArgumentResolver(ERROR_ARGUMENT_RESOLVER, SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER);
    private final Method method;
    private final JavaTypeLoader typeLoader = new JavaTypeLoader(this.getClass().getClassLoader());
    private ArgumentResolver<?>[] argumentResolvers;
    private Map<Parameter, ParameterGroupArgumentResolver<?>> parameterGroupResolvers;

    public MethodArgumentResolverDelegate(List<ParameterGroupModel> parameterGroupModels, Method method) {
        this.method = method;
        this.initArgumentResolvers(parameterGroupModels);
    }

    private void initArgumentResolvers(List<ParameterGroupModel> parameterGroupModels) {
        Object[] parameterTypes = this.method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            this.argumentResolvers = new ArgumentResolver[0];
            return;
        }
        this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        Parameter[] parameters = this.method.getParameters();
        this.parameterGroupResolvers = this.getParameterGroupResolvers(parameterGroupModels);
        List<String> paramNames = MuleExtensionAnnotationParser.getParamNames(this.method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
            ArgumentResolver argumentResolver = annotations.containsKey(Config.class) ? CONFIGURATION_ARGUMENT_RESOLVER : (annotations.containsKey(Connection.class) ? CONNECTOR_ARGUMENT_RESOLVER : (Error.class.isAssignableFrom((Class<?>)parameterType) ? ERROR_ARGUMENT_RESOLVER : (SourceCallbackContext.class.equals(parameterType) ? SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER : (IntrospectionUtils.isParameterContainer(annotations.keySet(), this.typeLoader.load((Type)parameterType)) && !((ParameterGroup)annotations.get(ParameterGroup.class)).showInDsl() ? (TypedValueArgumentResolver)((Object)this.parameterGroupResolvers.get(parameters[i])) : (ParameterResolver.class.equals(parameterType) ? new ParameterResolverArgumentResolver(paramNames.get(i)) : (TypedValue.class.equals(parameterType) ? new TypedValueArgumentResolver(paramNames.get(i)) : (Literal.class.equals(parameterType) ? new LiteralArgumentResolver(paramNames.get(i), parameterType) : (CompletionCallback.class.equals(parameterType) ? NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER : (MediaType.class.equals(parameterType) ? MEDIA_TYPE_ARGUMENT_RESOLVER : (AuthenticationHandler.class.equals(parameterType) ? SECURITY_CONTEXT_HANDLER : (FlowListener.class.equals(parameterType) ? FLOW_LISTENER_ARGUMENT_RESOLVER : (StreamingHelper.class.equals(parameterType) ? STREAMING_HELPER_ARGUMENT_RESOLVER : (SourceResult.class.equals(parameterType) ? SOURCE_RESULT_ARGUMENT_RESOLVER : (SourceCompletionCallback.class.equals(parameterType) ? ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER : new ByParameterNameArgumentResolver(paramNames.get(i))))))))))))))));
            this.argumentResolvers[i] = argumentResolver;
        }
    }

    @Override
    public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
        Object[] parameterValues = new Object[this.argumentResolvers.length];
        int i = 0;
        for (ArgumentResolver<?> argumentResolver : this.argumentResolvers) {
            parameterValues[i++] = argumentResolver.resolve(executionContext);
        }
        return this.resolvePrimitiveTypes(parameterTypes, parameterValues);
    }

    private Object[] resolvePrimitiveTypes(Class<?>[] parametersType, Object[] parameterValues) {
        Object[] resolvedParameters = new Object[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            Object parameterValue = parameterValues[i];
            resolvedParameters[i] = parameterValue == null ? this.resolvePrimitiveTypeDefaultValue(parametersType[i]) : parameterValue;
        }
        return resolvedParameters;
    }

    private Object resolvePrimitiveTypeDefaultValue(Class<?> type) {
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private Map<Parameter, ParameterGroupArgumentResolver<? extends Object>> getParameterGroupResolvers(List<ParameterGroupModel> parameterGroupModels) {
        return (Map)parameterGroupModels.stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null)).filter(group -> group != null && group.getContainer() instanceof Parameter).collect(Collectors.toImmutableMap(group -> (Parameter)group.getContainer(), ParameterGroupArgumentResolver::new));
    }
}

