/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.List;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.Field;

final class DsqlQueryMetadataResolver
implements OutputTypeResolver {
    private final QueryEntityResolver entityResolver;
    private final OutputTypeResolver nativeOutputResolver;

    DsqlQueryMetadataResolver(QueryEntityResolver entityResolver, OutputTypeResolver nativeOutputResolver) {
        this.entityResolver = entityResolver;
        this.nativeOutputResolver = nativeOutputResolver;
    }

    public String getCategoryName() {
        return this.nativeOutputResolver.getCategoryName();
    }

    public MetadataType getOutputType(MetadataContext context, Object query) throws MetadataResolvingException, ConnectionException {
        if (query instanceof DsqlQuery) {
            DsqlQuery dsqlQuery = (DsqlQuery)query;
            MetadataType entityMetadata = this.entityResolver.getEntityMetadata(context, dsqlQuery.getType().getName());
            final BaseTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
            final List fields = dsqlQuery.getFields();
            if (fields.size() == 1 && ((Field)fields.get(0)).getName().equals("*")) {
                return builder.arrayType().of(entityMetadata).build();
            }
            entityMetadata.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    ObjectTypeBuilder objectTypeBuilder = builder.arrayType().of().objectType();
                    objectType.getFields().stream().filter(p -> fields.stream().anyMatch(f -> f.getName().equalsIgnoreCase(p.getKey().getName().getLocalPart()))).forEach(p -> {
                        ObjectFieldTypeBuilder field = objectTypeBuilder.addField();
                        field.key(p.getKey().getName());
                        field.value(p.getValue());
                    });
                }
            });
            return builder.build();
        }
        return this.nativeOutputResolver.getOutputType(context, query);
    }
}

