/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.ParametersResolverProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionTypeMapper;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OperationMessageProcessor
extends ExtensionComponent<OperationModel>
implements Processor,
ParametersResolverProcessor,
EntityMetadataProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    protected final ExtensionModel extensionModel;
    protected final OperationModel operationModel;
    private final ResolverSet resolverSet;
    private final String target;
    private final String targetValue;
    private final EntityMetadataMediator entityMetadataMediator;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private ExecutionMediator executionMediator;
    private OperationExecutor operationExecutor;
    private PolicyManager policyManager;
    protected ReturnDelegate returnDelegate;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager) {
        super(extensionModel, operationModel, configurationProvider, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.targetValue = targetValue;
        this.entityMetadataMediator = new EntityMetadataMediator(operationModel);
        this.policyManager = policyManager;
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply((InternalEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).flatMap(Exceptions.checkedFunction(event -> (Publisher)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            OperationExecutionFunction operationExecutionFunction;
            Optional configuration;
            if (event.getInternalParameters().containsKey("core:interceptionResolvedContext")) {
                PrecalculatedExecutionContextAdapter operationContext = this.getPrecalculatedContext((InternalEvent)event);
                configuration = operationContext.getConfiguration();
                operationExecutionFunction = (parameters, operationEvent) -> this.doProcess(operationEvent, operationContext);
            } else {
                configuration = this.getConfiguration((InternalEvent)event);
                operationExecutionFunction = (parameters, operationEvent) -> {
                    ExecutionContextAdapter<OperationModel> operationContext;
                    try {
                        operationContext = this.createExecutionContext(configuration, parameters, operationEvent);
                    }
                    catch (MuleException e2) {
                        return Flux.error((Throwable)e2);
                    }
                    return this.doProcess(operationEvent, operationContext).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException(event, e, (AnnotatedObject)this));
                };
            }
            if (this.getLocation() != null) {
                return this.policyManager.createOperationPolicy((AnnotatedObject)this, event, this.getResolutionResult((InternalEvent)event, configuration), operationExecutionFunction).process(event);
            }
            return operationExecutionFunction.execute(this.getResolutionResult((InternalEvent)event, configuration), event);
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        })));
    }

    private PrecalculatedExecutionContextAdapter getPrecalculatedContext(InternalEvent event) {
        return (PrecalculatedExecutionContextAdapter)event.getInternalParameters().get("core:interceptionResolvedContext");
    }

    protected Mono<InternalEvent> doProcess(InternalEvent event, ExecutionContextAdapter<OperationModel> operationContext) {
        return this.executeOperation(operationContext).map(value -> this.asReturnValue(operationContext, value)).switchIfEmpty(Mono.fromCallable(() -> this.asReturnValue(operationContext, null))).onErrorMap(Exceptions::unwrap);
    }

    private InternalEvent asReturnValue(ExecutionContextAdapter<OperationModel> operationContext, Object value) {
        if (value instanceof InternalEvent) {
            return (InternalEvent)value;
        }
        return this.returnDelegate.asReturnValue(value, operationContext);
    }

    private Mono<Object> executeOperation(ExecutionContextAdapter operationContext) {
        return Mono.from(this.executionMediator.execute(this.operationExecutor, operationContext));
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, InternalEvent event) throws MuleException {
        return new DefaultExecutionContext<OperationModel>(this.extensionModel, configuration, resolvedParameters, this.operationModel, event, this.getCursorProviderFactory(), this.streamingManager, this.getLocation(), this.retryPolicyTemplate, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.returnDelegate = this.createReturnDelegate();
        this.operationExecutor = MuleExtensionUtils.getOperationExecutorFactory(this.operationModel).createExecutor(this.operationModel);
        this.executionMediator = this.createExecutionMediator();
        LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.operationExecutor, (boolean)true, (MuleContext)this.muleContext);
    }

    private ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid((ComponentModel)this.operationModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? new ValueReturnDelegate((ComponentModel)this.operationModel, this.getCursorProviderFactory(), this.muleContext) : new TargetReturnDelegate(this.target, this.targetValue, (ComponentModel)this.operationModel, this.getCursorProviderFactory(), this.muleContext);
    }

    private boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.operationModel.getName(), "an expression", "target"));
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.targetValue)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.operationModel.getName(), "something that is not an expression", "targetValue"));
        }
        return true;
    }

    protected Optional<String> getTarget() {
        return this.isTargetPresent() ? Optional.of(this.target) : Optional.empty();
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.operationExecutor, (Logger)LOGGER);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.entityMetadataMediator.getEntityKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.entityMetadataMediator.getEntityMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.connectionManager, this.muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]);
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(this.operationModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(this.operationModel.getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), this.operationModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        InternalEvent event = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new OperationParameterValueResolver(new LazyExecutionContext<OperationModel>(this.resolverSet, this.operationModel, this.extensionModel, ValueResolvingContext.from(event)));
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        ReactiveProcessor.ProcessingType processingType = ExecutionTypeMapper.asProcessingType(this.operationModel.getExecutionType());
        if (processingType == ReactiveProcessor.ProcessingType.CPU_LITE && !this.operationModel.isBlocking()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
        }
        return processingType;
    }

    public void resolveParameters(InternalEvent.Builder eventBuilder, BiConsumer<Map<String, Object>, ExecutionContext> afterConfigurer) throws MuleException {
        if (this.operationExecutor instanceof OperationArgumentResolverFactory) {
            List<Interceptor> interceptors;
            DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
            PrecalculatedExecutionContextAdapter executionContext = new PrecalculatedExecutionContextAdapter(this.createExecutionContext(eventBuilder.build()), this.operationExecutor);
            InterceptorsExecutionResult beforeExecutionResult = mediator.before(executionContext, interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext.getOperationExecutor()));
            if (beforeExecutionResult.isOk()) {
                Map<String, Object> resolvedArguments = ((OperationArgumentResolverFactory)this.operationExecutor).createArgumentResolver(this.operationModel).apply(executionContext);
                afterConfigurer.accept(resolvedArguments, executionContext);
                executionContext.changeEvent(eventBuilder.build());
            } else {
                this.disposeResolvedParameters(executionContext, interceptors);
                throw new DefaultMuleException("Interception execution for operation not ok", beforeExecutionResult.getThrowable());
            }
        }
    }

    public void disposeResolvedParameters(ExecutionContext<OperationModel> executionContext) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        List<Interceptor> interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)executionContext).getOperationExecutor() : this.operationExecutor);
        this.disposeResolvedParameters(executionContext, interceptors);
    }

    private void disposeResolvedParameters(ExecutionContext<OperationModel> executionContext, List<Interceptor> interceptors) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        mediator.after(executionContext, null, interceptors);
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(InternalEvent event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event);
    }

    private Map<String, Object> getResolutionResult(InternalEvent event, Optional<ConfigurationInstance> configuration) throws MuleException {
        return this.resolverSet.resolve(ValueResolvingContext.from(event, configuration)).asMap();
    }
}

