/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExecutableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultExecutionContext<M extends ComponentModel>
implements ExecutionContextAdapter<M> {
    private static final ExtensionTransactionFactory TRANSACTION_FACTORY = new ExtensionTransactionFactory();
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configuration;
    private final Map<String, Object> parameters;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final M componentModel;
    private final MuleContext muleContext;
    private InternalEvent event;
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final LazyValue<Optional<TransactionConfig>> transactionConfig;
    private final ComponentLocation location;
    private final RetryPolicyTemplate retryPolicyTemplate;

    public DefaultExecutionContext(ExtensionModel extensionModel, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, M componentModel, InternalEvent event, CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, ComponentLocation location, RetryPolicyTemplate retryPolicyTemplate, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.configuration = configuration;
        this.event = event;
        this.componentModel = componentModel;
        this.parameters = parameters;
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.muleContext = muleContext;
        this.location = location;
        this.retryPolicyTemplate = retryPolicyTemplate;
        boolean isTransactional = this.isTransactional(componentModel);
        this.transactionConfig = new LazyValue(() -> isTransactional ? Optional.of(this.buildTransactionConfig()) : Optional.empty());
    }

    public Optional<ConfigurationInstance> getConfiguration() {
        return this.configuration;
    }

    public boolean hasParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            return (T)this.parameters.get(parameterName);
        }
        throw new NoSuchElementException(parameterName);
    }

    @Override
    public <T> T getVariable(String key) {
        return (T)this.variables.get(key);
    }

    @Override
    public Object setVariable(String key, Object value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"null keys are not allowed");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"null values are not allowed");
        return this.variables.put(key, value);
    }

    @Override
    public <T> T removeVariable(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"null keys are not allowed");
        return (T)this.variables.remove(key);
    }

    @Override
    public InternalEvent getEvent() {
        return this.event;
    }

    @Override
    public void changeEvent(InternalEvent updated) {
        Objects.requireNonNull(this.event);
        this.event = updated;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public M getComponentModel() {
        return this.componentModel;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    @Override
    public Optional<TransactionConfig> getTransactionConfig() {
        return (Optional)this.transactionConfig.get();
    }

    @Override
    public StreamingManager getStreamingManager() {
        return this.streamingManager;
    }

    @Override
    public ComponentLocation getComponentLocation() {
        return this.location;
    }

    @Override
    public Optional<RetryPolicyTemplate> getRetryPolicyTemplate() {
        return Optional.ofNullable(this.retryPolicyTemplate);
    }

    private TransactionConfig buildTransactionConfig() {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        transactionConfig.setFactory((TransactionFactory)TRANSACTION_FACTORY);
        return transactionConfig;
    }

    private OperationTransactionalAction getTransactionalAction() {
        try {
            Optional<ParameterModel> transactionalParameter = this.getTransactionalActionParameter();
            if (transactionalParameter.isPresent()) {
                return (OperationTransactionalAction)this.getParameter(transactionalParameter.get().getName());
            }
            throw new NoSuchElementException();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("Operation '%s' from extension '%s' is transactional but no transactional action defined", this.componentModel.getName(), this.extensionModel.getName()));
        }
    }

    private Optional<ParameterModel> getTransactionalActionParameter() {
        return this.componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(TransactionalActionModelProperty.class).isPresent()).findAny();
    }

    private boolean isTransactional(M componentModel) {
        return componentModel instanceof ExecutableComponentModel && ((ExecutableComponentModel)componentModel).isTransactional();
    }
}

