/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.process.Chain;
import org.mule.runtime.extension.api.stereotype.MuleStereotypeDefinition;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class StereotypesDeclarationEnricher
implements DeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader((ClassLoader)extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate().apply(extensionLoadingContext));
    }

    private static class EnricherDelegate {
        private final Map<StereotypeDefinition, StereotypeModel> stereotypes = new HashMap<StereotypeDefinition, StereotypeModel>();

        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            Optional implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
            final String namespace = this.getStereotypePrefix(extensionDeclarer);
            final StereotypeModel defaultConfigStereotype = StereotypeModelBuilder.newStereotype((String)"CONFIG", (String)namespace).withParent(MuleStereotypes.CONFIG).build();
            final StereotypeModel defaultConnectionStereotype = StereotypeModelBuilder.newStereotype((String)"CONNECTION", (String)namespace).withParent(MuleStereotypes.CONNECTION).build();
            if (implementingType.isPresent()) {
                new IdempotentDeclarationWalker(){

                    protected void onConfiguration(ConfigurationDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> this.addStereotypes(namespace, (Class<?>)declaringType, (WithStereotypesDeclaration)declaration, defaultConfigStereotype));
                    }

                    protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> this.addStereotypes(namespace, (Class<?>)declaringType, (WithStereotypesDeclaration)declaration, defaultConnectionStereotype));
                    }

                    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                        declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(MethodWrapper::new).ifPresent(methodElement -> this.addStereotypes(namespace, methodElement, (ComponentDeclaration)declaration, MuleStereotypes.PROCESSOR));
                    }

                    protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> this.addStereotypes(namespace, (Class<?>)declaringType, (WithStereotypesDeclaration)declaration, MuleStereotypes.SOURCE));
                    }
                }.walk(declaration);
            }
            this.resolveStereotypes(declaration, namespace);
        }

        private void resolveStereotypes(ExtensionDeclaration declaration, String namespace) {
            Function<Class, StereotypeModel> resolver = def -> this.getStereotype((Class<? extends StereotypeDefinition>)def, namespace);
            declaration.getTypes().forEach(type -> this.resolveStereotype((ObjectType)type, (Function<Class<? extends StereotypeDefinition>, StereotypeModel>)resolver));
        }

        private void resolveStereotype(ObjectType type, final Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
            type.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    objectType.getAnnotation(StereotypeTypeAnnotation.class).ifPresent(a -> a.resolveStereotype(resolver));
                    objectType.getFields().forEach(f -> f.getValue().accept((MetadataTypeVisitor)this));
                }

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }

                public void visitUnion(UnionType unionType) {
                    unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
                }

                public void visitIntersection(IntersectionType intersectionType) {
                    intersectionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
                }
            });
        }

        private void addStereotypes(String namespace, MethodWrapper methodElement, ComponentDeclaration declaration, StereotypeModel defaultStereotype) {
            Stereotype stereotypes = methodElement.getMethod().getAnnotation(Stereotype.class);
            if (stereotypes == null) {
                this.addStereotypes(namespace, methodElement.getDeclaringClass(), (WithStereotypesDeclaration)declaration, defaultStereotype);
            } else {
                this.addStereotypes(namespace, (WithStereotypesDeclaration)declaration, stereotypes, defaultStereotype);
            }
            methodElement.getParameters().stream().filter(p -> Chain.class.equals((Object)p.getType().getDeclaringClass())).findFirst().ifPresent(param -> declaration.getNestedComponents().stream().filter(NestedChainDeclaration.class::isInstance).findFirst().ifPresent(model -> this.addAllowedStereotypes(namespace, (ExtensionParameter)param, (NestedChainDeclaration)model)));
        }

        void addStereotypes(String namespace, Class<?> annotatedClass, WithStereotypesDeclaration declaration, StereotypeModel defaultStereotype) {
            this.addStereotypes(namespace, declaration, IntrospectionUtils.getAnnotation(annotatedClass, Stereotype.class), defaultStereotype);
        }

        private void addStereotypes(String namespace, WithStereotypesDeclaration declaration, Stereotype customStereotype, StereotypeModel defaultStereotype) {
            if (customStereotype != null) {
                declaration.withStereotype(this.getStereotype(customStereotype.value(), namespace));
            } else {
                declaration.withStereotype(defaultStereotype);
            }
        }

        private StereotypeModel getStereotype(Class<? extends StereotypeDefinition> definitionClass, String namespace) {
            try {
                return this.getStereotype((StereotypeDefinition)ClassUtils.instantiateClass(definitionClass, (Object[])new Object[0]), namespace);
            }
            catch (Exception e) {
                throw new IllegalModelDefinitionException("Invalid StereotypeDefinition found with name: " + definitionClass.getName(), (Throwable)e);
            }
        }

        private String getStereotypePrefix(ExtensionDeclarer extensionDeclarer) {
            return ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getXmlDslModel().getPrefix().toUpperCase();
        }

        StereotypeModel getStereotype(StereotypeDefinition stereotypeDefinition, String namespace) {
            return this.stereotypes.computeIfAbsent(stereotypeDefinition, definition -> {
                StereotypeModelBuilder builder = StereotypeModelBuilder.newStereotype((String)stereotypeDefinition.getName(), (String)namespace);
                stereotypeDefinition.getParent().ifPresent(parent -> {
                    String parentNamespace = parent instanceof MuleStereotypeDefinition ? "MULE" : namespace;
                    builder.withParent(StereotypeModelBuilder.newStereotype((String)parent.getName(), (String)parentNamespace).build());
                });
                return builder.build();
            });
        }

        private void addAllowedStereotypes(String namespace, ExtensionParameter parameter, NestedChainDeclaration declaration) {
            Optional<AllowedStereotypes> stereotypes = parameter.getAnnotation(AllowedStereotypes.class);
            if (stereotypes.isPresent()) {
                for (Class definition : stereotypes.get().value()) {
                    declaration.addAllowedStereotype(this.getStereotype(definition, namespace));
                }
            } else {
                declaration.addAllowedStereotype(MuleStereotypes.PROCESSOR);
            }
        }
    }
}

