/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;

public final class ParameterAllowedStereotypesDeclarionEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                declaration.getModelProperty(ImplementingParameterModelProperty.class).ifPresent(param -> declaration.setAllowedStereotypeModels(ParameterAllowedStereotypesDeclarionEnricher.this.getStereotypes(param.getParameter())));
                declaration.getModelProperty(DeclaringMemberModelProperty.class).ifPresent(field -> declaration.setAllowedStereotypeModels(ParameterAllowedStereotypesDeclarionEnricher.this.getStereotypes(field.getDeclaringField())));
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private List<StereotypeModel> getStereotypes(AnnotatedElement element) {
        ConfigReferences references = element.getAnnotation(ConfigReferences.class);
        if (references != null) {
            return Arrays.stream(references.value()).map(ref -> StereotypeModelBuilder.newStereotype((String)ref.name(), (String)ref.namespace()).withParent(MuleStereotypes.CONFIG).build()).collect(Collectors.toList());
        }
        ConfigReference ref2 = element.getAnnotation(ConfigReference.class);
        if (ref2 != null) {
            return Collections.singletonList(StereotypeModelBuilder.newStereotype((String)ref2.name(), (String)ref2.namespace()).withParent(MuleStereotypes.CONFIG).build());
        }
        if (element.getAnnotation(FlowReference.class) != null) {
            return Collections.singletonList(MuleStereotypes.FLOW);
        }
        if (element.getAnnotation(ObjectStoreReference.class) != null) {
            return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
        }
        return Collections.emptyList();
    }
}

