/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class OperationReturnTypeModelValidator
implements ExtensionModelValidator {
    private final List<Class<?>> illegalReturnTypes = ImmutableList.of(CoreEvent.class, Message.class);

    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operationModel) {
                if (operationModel.getOutput() == null || operationModel.getOutput().getType() == null) {
                    throw OperationReturnTypeModelValidator.this.missingReturnTypeException(extensionModel, operationModel);
                }
                Class returnType = JavaTypeUtils.getType((MetadataType)operationModel.getOutput().getType());
                OperationReturnTypeModelValidator.this.illegalReturnTypes.stream().filter(forbiddenType -> forbiddenType.isAssignableFrom(returnType)).findFirst().ifPresent(forbiddenType -> problemsReporter.addError(new Problem((NamedObject)operationModel, String.format("Operation '%s' in Extension '%s' specifies '%s' as a return type. Operations are not allowed to return objects of that type", operationModel.getName(), extensionModel.getName(), forbiddenType.getName()))));
            }
        }.walk(extensionModel);
    }

    private IllegalModelDefinitionException missingReturnTypeException(ExtensionModel model, OperationModel operationModel) {
        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' in Extension '%s' is missing a return type", operationModel.getName(), model.getName()));
    }
}

