/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ConfigurationDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.OperationDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.SourcesDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.loader.utils.JavaParserUtils;
import org.mule.sdk.api.annotation.Configuration;

final class ExtensionDescriptionDocumenter
extends AbstractDescriptionDocumenter {
    private final RoundEnvironment roundEnv;
    private final ConfigurationDescriptionDocumenter configDocumenter;
    private final OperationDescriptionDocumenter operationDocumenter;
    private final SourcesDescriptionDocumenter sourceDocumenter;

    ExtensionDescriptionDocumenter(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        super(processingEnvironment);
        this.roundEnv = roundEnvironment;
        this.operationDocumenter = new OperationDescriptionDocumenter(this.processingEnv);
        this.sourceDocumenter = new SourcesDescriptionDocumenter(this.processingEnv);
        this.configDocumenter = new ConfigurationDescriptionDocumenter(processingEnvironment);
    }

    void document(ExtensionDeclaration extensionDeclaration, TypeElement extensionElement) {
        extensionDeclaration.setDescription(processor.getJavaDocSummary(this.processingEnv, extensionElement));
        this.sourceDocumenter.document(extensionElement, new WithSourcesDeclaration[]{extensionDeclaration});
        this.operationDocumenter.document(extensionElement, new WithOperationsDeclaration[]{extensionDeclaration});
        this.documentConfigurations(extensionDeclaration, extensionElement);
    }

    private void documentConfigurations(ExtensionDeclaration extensionDeclaration, TypeElement extensionElement) {
        Set<TypeElement> configurations = processor.getTypeElementsAnnotatedWith(org.mule.runtime.extension.api.annotation.Configuration.class, this.roundEnv);
        configurations.addAll(processor.getTypeElementsAnnotatedWith(Configuration.class, this.roundEnv));
        if (!configurations.isEmpty()) {
            configurations.forEach(config -> this.findMatchingConfiguration(extensionDeclaration, (TypeElement)config).ifPresent(configDeclaration -> this.configDocumenter.document(extensionDeclaration, (ConfigurationDeclaration)configDeclaration, (TypeElement)config)));
            this.configDocumenter.documentConnectionProviders((ConnectedDeclaration<?>)extensionDeclaration, extensionElement);
        } else {
            this.configDocumenter.document(extensionDeclaration, (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0), extensionElement);
            ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).setDescription("Default configuration");
        }
    }

    private Optional<ConfigurationDeclaration> findMatchingConfiguration(ExtensionDeclaration declaration, TypeElement element) {
        List configurations = declaration.getConfigurations();
        if (configurations.size() == 1) {
            return Optional.of((ConfigurationDeclaration)configurations.get(0));
        }
        return configurations.stream().filter(config -> {
            String defaultNaming;
            String annotationName = JavaParserUtils.mapReduceAnnotation((Element)element, org.mule.runtime.extension.api.annotation.Configuration.class, Configuration.class, org.mule.runtime.extension.api.annotation.Configuration::name, Configuration::name).orElse("");
            String name = config.getName();
            return name.equals(defaultNaming = NameUtils.hyphenize((String)element.getSimpleName().toString())) || name.equals(annotationName) || name.equals("config");
        }).findAny();
    }
}

