/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.UnnamedComponent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ChildContextChain;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ProcessorChainValueResolver;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;

public abstract class ComponentMessageProcessorObjectFactory<M extends ComponentModel, P extends ComponentMessageProcessor>
extends AbstractExtensionObjectFactory<P> {
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    @Inject
    private StreamingManager streamingManager;
    protected final ExtensionModel extensionModel;
    protected final M componentModel;
    protected ConfigurationProvider configurationProvider;
    protected String target = "";
    protected String targetValue = "#[payload]";
    protected CursorProviderFactory cursorProviderFactory;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected List<Processor> nestedProcessors;

    public ComponentMessageProcessorObjectFactory(ExtensionModel extensionModel, M componentModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
    }

    public P doGetObject() {
        MessageProcessorChain chain;
        if (this.nestedProcessors != null) {
            chain = MessageProcessors.newChain(Optional.empty(), this.nestedProcessors, (ComponentTracer)this.componentTracerFactory.fromComponent(UnnamedComponent.getUnnamedComponent(), "message:processor", ""));
            this.componentModel.getNestedComponents().stream().filter(NestedChainModel.class::isInstance).findFirst().ifPresent(chainModel -> this.parameters.put(chainModel.getName(), new ProcessorChainValueResolver(chainModel, chain, this.streamingManager)));
            HashMap<QName, Object> annotations = new HashMap<QName, Object>(this.getAnnotations());
            ComponentLocation chainLocation = this.getLocation();
            annotations.put(LOCATION_KEY, ((DefaultComponentLocation)chainLocation).appendProcessorsPart());
            annotations.put(ChildContextChain.CHAIN_OWNER_LOCATION_KEY, chainLocation);
            chain.setAnnotations(annotations);
        } else {
            chain = null;
        }
        return (P)((ComponentMessageProcessor)this.getMessageProcessorBuilder().setConfigurationProvider(this.configurationProvider).setParameters(this.parameters).setTarget(this.target).setTargetValue(this.targetValue).setCursorProviderFactory(this.cursorProviderFactory).setRetryPolicyTemplate(this.retryPolicyTemplate).setNestedChain(chain).setClassLoader(Thread.currentThread().getContextClassLoader()).build());
    }

    protected abstract ComponentMessageProcessorBuilder<M, P> getMessageProcessorBuilder();

    public void setConfigurationProvider(ConfigurationProvider configuration) {
        this.configurationProvider = configuration;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public void setNestedProcessors(List<Processor> processors) {
        this.nestedProcessors = processors;
    }
}

