/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.resolver;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingUtils;
import org.mule.runtime.module.extension.internal.config.dsl.object.CharsetValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.MediaTypeValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.resolver.BasicTypeValueResolverFactoryTypeVisitor;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ValueResolverFactoryTypeVisitor
extends BasicTypeValueResolverFactoryTypeVisitor {
    private final List<ValueResolverParsingDelegate> valueResolverParsingDelegates = ImmutableList.of((Object)new CharsetValueResolverParsingDelegate(), (Object)new MediaTypeValueResolverParsingDelegate());
    private final ValueResolverParsingDelegate defaultValueResolverParsingDelegate = new DefaultValueResolverParsingDelegate();
    private final DslSyntaxResolver dslSyntaxResolver;
    private final Object defaultValue;
    private final boolean content;
    private final boolean acceptsReferences;

    public ValueResolverFactoryTypeVisitor(DslSyntaxResolver dslSyntaxResolver, String parameterName, Object value, Object defaultValue, boolean content, boolean acceptsReferences, Class<?> expectedClass) {
        super(parameterName, value, expectedClass);
        this.dslSyntaxResolver = dslSyntaxResolver;
        this.defaultValue = defaultValue;
        this.content = content;
        this.acceptsReferences = acceptsReferences;
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        this.setResolver(this.parseDate(this.getValue(), (MetadataType)dateTimeType, this.defaultValue));
    }

    public void visitDate(DateType dateType) {
        this.setResolver(this.parseDate(this.getValue(), (MetadataType)dateType, this.defaultValue));
    }

    public void visitObject(ObjectType objectType) {
        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
            this.defaultVisit((MetadataType)objectType);
            return;
        }
        Optional delegate = ExtensionParsingUtils.locateParsingDelegate(this.valueResolverParsingDelegates, objectType);
        Optional typeDsl = this.dslSyntaxResolver.resolve((MetadataType)objectType);
        Object valueResolver = delegate.isPresent() && typeDsl.isPresent() ? (ValueResolver)delegate.get().parse(this.getValue().toString(), objectType, (DslElementSyntax)typeDsl.get()) : (this.acceptsReferences ? (ValueResolver)this.defaultValueResolverParsingDelegate.parse(this.getValue().toString(), objectType, null) : new StaticValueResolver(this.getValue(), this.content));
        this.setResolver((ValueResolver)valueResolver);
    }

    protected void defaultVisit(MetadataType metadataType) {
        ValueResolver delegateResolver = ExtensionParsingUtils.locateParsingDelegate(this.valueResolverParsingDelegates, metadataType).map(delegate -> (ValueResolver)delegate.parse(this.getValue().toString(), metadataType, null)).orElseGet(() -> this.acceptsReferences ? (ValueResolver)this.defaultValueResolverParsingDelegate.parse(this.getValue().toString(), metadataType, null) : new TypeSafeValueResolverWrapper((ValueResolver)new StaticValueResolver(this.getValue(), this.content), this.getExpectedClass()));
        this.setResolver(delegateResolver);
    }

    private ValueResolver parseDate(Object value, MetadataType dateType, Object defaultValue) {
        Class type = JavaTypeUtils.getType((MetadataType)dateType);
        if (MuleExtensionUtils.isExpression((Object)value)) {
            return new TypeSafeExpressionValueResolver((String)value, type, IntrospectionUtils.toDataType((MetadataType)dateType));
        }
        if (value == null) {
            if (defaultValue == null) {
                return new StaticValueResolver(null, this.content);
            }
            value = defaultValue;
        }
        return this.doParseDate(value, type);
    }

    private ValueResolver doParseDate(Object value, Class<?> type) {
        if (value instanceof String) {
            Comparable<Date> constructedValue = null;
            DateTime dateTime = this.getParsedDateTime((String)value);
            if (type.equals(LocalDate.class)) {
                constructedValue = LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            } else if (type.equals(Date.class)) {
                constructedValue = dateTime.toDate();
            } else if (type.equals(LocalDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = LocalDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            } else if (type.equals(Calendar.class)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toDate());
                constructedValue = calendar;
            } else if (type.equals(ZonedDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = ZonedDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            }
            if (constructedValue == null) {
                throw new IllegalArgumentException(String.format("Could not construct value of type '%s' from String '%s'", type.getName(), value));
            }
            value = constructedValue;
        }
        if (this.hasValidType(value)) {
            return new StaticValueResolver(value, this.content);
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to a valid date type", value != null ? value.getClass().getName() : "null"));
    }

    private DateTime getParsedDateTime(String value) {
        try {
            return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' according to ISO 8601", value));
        }
    }

    private boolean hasValidType(Object value) {
        return value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Calendar || value instanceof ZonedDateTime;
    }
}

