/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.ProblemsHandler;
import org.mule.runtime.module.extension.api.loader.java.type.WithElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class AnnotationProcessorProblemsHandler
implements ProblemsHandler {
    private final Messager messager;

    AnnotationProcessorProblemsHandler(ProcessingEnvironment processingEnvironment) {
        this.messager = processingEnvironment.getMessager();
    }

    public void handleProblems(ProblemsReporter problemsReporter) {
        problemsReporter.getWarnings().forEach(problem -> this.messager.printMessage(Diagnostic.Kind.WARNING, problem.getMessage(), this.getElement(problem.getComponent())));
        problemsReporter.getErrors().forEach(problem -> this.messager.printMessage(Diagnostic.Kind.ERROR, problem.getMessage(), this.getElement(problem.getComponent())));
    }

    private Element getElement(NamedObject component) {
        Optional optionalElement;
        if (component instanceof EnrichableModel) {
            EnrichableModel enrichableModel = (EnrichableModel)component;
            Element element = this.getElement(enrichableModel, ExtensionOperationDescriptorModelProperty.class, mp -> mp.getOperationElement().getElement());
            if (element != null) {
                return element;
            }
            element = this.getElement(enrichableModel, ExtensionParameterDescriptorModelProperty.class, mp -> mp.getExtensionParameter().getElement());
            if (element != null) {
                return element;
            }
            element = this.getElement(enrichableModel, ExtensionTypeDescriptorModelProperty.class, mp -> mp.getType().getElement());
            if (element != null) {
                return element;
            }
        }
        if (component instanceof WithElement && (optionalElement = ((WithElement)component).getElement()).isPresent()) {
            return (Element)optionalElement.get();
        }
        return null;
    }

    private <T extends ModelProperty> Element getElement(EnrichableModel enrichableModel, Class<T> modelPropertyClass, Function<T, Optional<? extends Element>> elementFunction) {
        return enrichableModel.getModelProperty(modelPropertyClass).flatMap(elementFunction::apply).orElse(null);
    }
}

