/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.resources.ProcessingEnvironmentAware;
import org.mule.runtime.module.extension.internal.resources.manifest.ClassPackageFinder;
import org.mule.runtime.module.extension.internal.resources.manifest.DefaultClassPackageFinder;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedPackagesCollector;
import org.mule.runtime.module.extension.internal.resources.manifest.ProcessingEnvironmentClassPackageFinder;

public class MulePluginDescriptorGenerator
implements GeneratedResourceFactory,
ProcessingEnvironmentAware {
    private static final String AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR = "auto-generated-mule-artifact.json";
    private ProcessingEnvironment processingEnvironment;

    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        Optional typeProperty = extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        if (!typeProperty.isPresent()) {
            return Optional.empty();
        }
        DefaultClassPackageFinder defaultClassPackageFinder = new DefaultClassPackageFinder();
        if (this.processingEnvironment != null) {
            defaultClassPackageFinder.addAdditionalPackageFinder((ClassPackageFinder)new ProcessingEnvironmentClassPackageFinder(this.processingEnvironment));
        }
        ExportedPackagesCollector exportCollector = new ExportedPackagesCollector(extensionModel, (ClassPackageFinder)defaultClassPackageFinder);
        MulePluginModel.MulePluginModelBuilder builder = new MulePluginModel.MulePluginModelBuilder();
        builder.setName(extensionModel.getName());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptorBuilder().setId("mule").addProperty("exportedPackages", (Object)exportCollector.getExportedPackages()).addProperty("exportedResources", (Object)exportCollector.getExportedResources()).addProperty("privilegedExportedPackages", (Object)exportCollector.getPrivilegedExportedPackages()).addProperty("privilegedArtifactIds", (Object)exportCollector.getPrivilegedArtifacts()).build());
        builder.withExtensionModelDescriber().setId(this.getLoaderId(extensionModel)).addProperty("type", (Object)((ExtensionTypeDescriptorModelProperty)typeProperty.get()).getType().getTypeName()).addProperty("version", (Object)extensionModel.getVersion());
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        Optional licenseModelPropertyOptional = extensionModel.getModelProperty(LicenseModelProperty.class);
        builder.setRequiredProduct(extensionModel.getCategory().equals((Object)Category.COMMUNITY) ? Product.MULE : Product.MULE_EE);
        licenseModelPropertyOptional.ifPresent(licenseModelProperty -> {
            builder.setRequiredProduct(licenseModelProperty.requiresEeLicense() ? Product.MULE_EE : Product.MULE);
            if (licenseModelProperty.requiresEeLicense()) {
                builder.withLicenseModel().setAllowsEvaluationLicense(licenseModelProperty.isAllowsEvaluationLicense());
                licenseModelProperty.getRequiredEntitlement().ifPresent(requiredEntitlement -> builder.withLicenseModel().setProvider(extensionModel.getVendor()).setRequiredEntitlement(requiredEntitlement));
            }
        });
        this.setMetadataFromSource(builder);
        String descriptorJson = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)builder.build());
        return Optional.of(new GeneratedResource(false, AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR, descriptorJson.getBytes()));
    }

    private void setMetadataFromSource(MulePluginModel.MulePluginModelBuilder builder) {
        this.readPluginModelFromSource().ifPresent(sourcePluginModel -> {
            if (sourcePluginModel.getMinMuleVersion() != null) {
                builder.setMinMuleVersion(sourcePluginModel.getMinMuleVersion());
            }
            if (sourcePluginModel.getClassLoaderModelLoaderDescriptor() != null) {
                builder.withClassLoaderModelDescriptorLoader(sourcePluginModel.getClassLoaderModelLoaderDescriptor());
            }
        });
    }

    private Optional<MulePluginModel> readPluginModelFromSource() {
        if (this.processingEnvironment == null) {
            return Optional.empty();
        }
        try {
            String extensionResourcesLocation = this.processingEnvironment.getOptions().get("extension.resources");
            Path path = Paths.get(extensionResourcesLocation, "META-INF", "mule-artifact", "mule-artifact.json");
            if (!path.toFile().exists()) {
                return Optional.empty();
            }
            String sourceMuleArtifactJson = Files.readString(path, StandardCharsets.UTF_8);
            return Optional.of((MulePluginModel)new MulePluginModelJsonSerializer().deserialize(sourceMuleArtifactJson));
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private String getLoaderId(ExtensionModel extensionModel) {
        return "java";
    }

    @Override
    public void setProcessingEnvironment(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }
}

