/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.resources;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.resources.BaseExtensionResourcesGeneratorAnnotationProcessor;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;

public abstract class ClassExtensionResourcesGeneratorAnnotationProcessor
extends BaseExtensionResourcesGeneratorAnnotationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String extensionClassesLocation = this.processingEnv.getOptions().get("extension.classes");
        if (extensionClassesLocation != null) {
            try {
                processor.setExtensionClassLoader(new URLClassLoader(new URL[]{Paths.get(extensionClassesLocation, new String[0]).toUri().toURL()}, this.getClass().getClassLoader()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return super.process(annotations, roundEnv);
    }

    @Override
    public ExtensionElement toExtensionElement(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        Class extensionClass = processor.classFor(typeElement, processingEnvironment).orElseThrow(() -> new RuntimeException(String.format("Unable to load class for extension: %s", typeElement.getQualifiedName().toString())));
        return new ExtensionTypeWrapper(extensionClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(extensionClass.getClassLoader()));
    }

    @Override
    protected boolean shouldProcess(TypeElement extensionElement, ProcessingEnvironment processingEnv) {
        return processor.classFor(extensionElement, processingEnv).isPresent();
    }
}

